/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DefaultDocumentFormatGetter;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.FormatGetter;
import com.marklogic.client.ext.file.SupportsAdditionalBinaryExtensions;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.Format;
import java.util.Arrays;

public class FormatDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor,
SupportsAdditionalBinaryExtensions {
    private FormatGetter formatGetter;

    public FormatDocumentFileProcessor() {
        this(new DefaultDocumentFormatGetter());
    }

    public FormatDocumentFileProcessor(FormatGetter formatGetter) {
        this.formatGetter = formatGetter;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        Format format = this.formatGetter.getFormat(documentFile.getResource());
        if (format != null) {
            documentFile.setFormat(format);
        }
        return documentFile;
    }

    @Override
    public void setAdditionalBinaryExtensions(String[] extensions) {
        if (this.formatGetter instanceof DefaultDocumentFormatGetter) {
            DefaultDocumentFormatGetter ddfg = (DefaultDocumentFormatGetter)this.formatGetter;
            for (String ext : extensions) {
                ddfg.getBinaryExtensions().add(ext);
            }
        } else {
            this.logger.warn("FormatGetter is not an instanceof DefaultDocumentFormatGetter, so unable to add additionalBinaryExtensions: " + Arrays.asList(extensions));
        }
    }

    public FormatGetter getFormatGetter() {
        return this.formatGetter;
    }

    public void setFormatGetter(FormatGetter formatGetter) {
        this.formatGetter = formatGetter;
    }
}

