/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientBuilder;
import com.marklogic.client.ext.ConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.ssl.SslConfig;
import com.marklogic.client.ext.ssl.SslUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class DefaultConfiguredDatabaseClientFactory
implements ConfiguredDatabaseClientFactory {
    @Override
    public DatabaseClient newDatabaseClient(DatabaseClientConfig config) {
        SslConfig sslConfig;
        DatabaseClientBuilder builder = new DatabaseClientBuilder().withHost(config.getHost()).withPort(config.getPort()).withBasePath(config.getBasePath()).withDatabase(config.getDatabase()).withConnectionType(config.getConnectionType()).withUsername(config.getUsername()).withPassword(config.getPassword()).withCertificateFile(config.getCertFile()).withCertificatePassword(config.getCertPassword()).withKerberosPrincipal(config.getExternalName()).withSAMLToken(config.getSamlToken()).withCloudApiKey(config.getCloudApiKey()).withSSLProtocol(config.getSslProtocol()).withSSLHostnameVerifier(config.getSslHostnameVerifier()).withKeyStorePath(config.getKeyStorePath()).withKeyStorePassword(config.getKeyStorePassword()).withKeyStoreType(config.getKeyStoreType()).withKeyStoreAlgorithm(config.getKeyStoreAlgorithm()).withTrustStorePath(config.getTrustStorePath()).withTrustStorePassword(config.getTrustStorePassword()).withTrustStoreType(config.getTrustStoreType()).withTrustStoreAlgorithm(config.getTrustStoreAlgorithm());
        if (config.getSecurityContextType() != null) {
            builder.withAuthType(config.getSecurityContextType().name());
        }
        if ((sslConfig = this.determineSslConfig(config)) != null) {
            builder.withSSLContext(sslConfig.getSslContext()).withTrustManager(sslConfig.getTrustManager());
        }
        return builder.build();
    }

    private SslConfig determineSslConfig(DatabaseClientConfig config) {
        SSLContext sslContext = config.getSslContext();
        X509TrustManager trustManager = config.getTrustManager();
        if (sslContext != null && trustManager != null) {
            return new SslConfig(sslContext, trustManager);
        }
        String protocol = config.getSslProtocol();
        return protocol != null && protocol.trim().length() > 0 ? SslUtil.configureUsingTrustManagerFactory(protocol, config.getTrustManagementAlgorithm()) : null;
    }
}

