/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.template;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.template.TemplateBuilder;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;

public class GenericTemplateBuilder
extends LoggingObject
implements TemplateBuilder {
    private Map<String, Object> defaultPropertyMap;
    private Class<?> resourceClass;

    public GenericTemplateBuilder(Class<? extends Resource> resourceClass) {
        this.resourceClass = resourceClass;
        this.defaultPropertyMap = new HashMap<String, Object>();
    }

    public void addDefaultPropertyValue(String propertyName, Object value) {
        this.defaultPropertyMap.put(propertyName, value);
    }

    @Override
    public Resource buildTemplate(Map<String, Object> propertyMap) {
        Resource r;
        try {
            r = (Resource)this.resourceClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Map<String, Object> combinedMap = this.combinePropertyMaps(propertyMap);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using combined property map: " + combinedMap);
        }
        this.populateProperties(r, combinedMap);
        return r;
    }

    protected void populateProperties(Resource r, Map<String, Object> propertyMap) {
        BeanWrapperImpl bw = new BeanWrapperImpl((Object)r);
        for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
            String javaPropertyName;
            String manageApiPropertyName;
            if (pd.getWriteMethod() == null || pd.getReadMethod() == null || !propertyMap.containsKey(manageApiPropertyName = this.toLowercaseHyphenated(javaPropertyName = pd.getName()))) continue;
            bw.setPropertyValue(javaPropertyName, propertyMap.get(manageApiPropertyName));
        }
    }

    protected Map<String, Object> combinePropertyMaps(Map<String, Object> propertyMap) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (this.defaultPropertyMap != null) {
            for (String key : this.defaultPropertyMap.keySet()) {
                newMap.put(key, this.defaultPropertyMap.get(key));
            }
        }
        if (propertyMap != null) {
            for (String key : propertyMap.keySet()) {
                newMap.put(key, propertyMap.get(key));
            }
        }
        return newMap;
    }

    protected String toLowercaseHyphenated(String javaPropertyName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < javaPropertyName.length(); ++i) {
            char ch = javaPropertyName.charAt(i);
            if (Character.isUpperCase(ch)) {
                sb.append("-").append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

