/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.rebalancer;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.rebalancer.PartitionProperties;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.IOException;
import org.springframework.http.ResponseEntity;

public class PartitionManager
extends AbstractResourceManager {
    private String databaseIdOrName;

    public PartitionManager(ManageClient client, String databaseIdOrName) {
        super(client);
        this.databaseIdOrName = databaseIdOrName;
        this.setUpdateAllowed(false);
    }

    @Override
    public String getResourcesPath() {
        return this.format("/manage/v2/databases/%s/partitions", new Object[]{this.databaseIdOrName});
    }

    @Override
    protected String getIdFieldName() {
        return "partition-name";
    }

    public ResponseEntity<String> takePartitionOnline(String partitionName) {
        return this.getManageClient().putJson(this.getPropertiesPath(partitionName, new String[0]), "{\"availability\":\"online\"}");
    }

    public ResponseEntity<String> takePartitionOffline(String partitionName) {
        return this.getManageClient().putJson(this.getPropertiesPath(partitionName, new String[0]), "{\"availability\":\"offline\"}");
    }

    public PartitionProperties getPartitionProperties(String partitionName) {
        JsonNode json = this.getManageClient().getJsonNode(this.getPropertiesPath(partitionName, new String[0]));
        if (json != null && json.has("partition-properties")) {
            JsonNode props = json.get("partition-properties");
            try {
                return (PartitionProperties)ObjectMapperFactory.getObjectMapper().readerFor(PartitionProperties.class).readValue(props.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to unmarshal partition properties JSON response: " + json, e);
            }
        }
        throw new RuntimeException("Unexpected payload for partition properties, could not find partition-properties key; payload; " + json);
    }
}

