/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.flexrep;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.rest.util.Fragment;

public class TargetManager
extends AbstractResourceManager {
    private String databaseIdOrName;
    private String configIdOrName;

    public TargetManager(ManageClient client, String databaseIdOrName, String configIdOrName) {
        super(client);
        this.databaseIdOrName = databaseIdOrName;
        this.configIdOrName = configIdOrName;
    }

    @Override
    public String getResourcesPath() {
        return this.format("/manage/v2/databases/%s/flexrep/configs/%s/targets", new Object[]{this.databaseIdOrName, this.configIdOrName});
    }

    public void disableAllTargets() {
        for (String name : this.getAsXml().getListItemNameRefs()) {
            this.disableTarget(name);
        }
    }

    public void enableAllTargets() {
        for (String name : this.getAsXml().getListItemNameRefs()) {
            this.enableTarget(name);
        }
    }

    public void disableTarget(String targetIdOrName) {
        this.getManageClient().putJson(this.getPropertiesPath(targetIdOrName, new String[0]), "{\"enabled\":false}");
    }

    public void enableTarget(String targetIdOrName) {
        this.getManageClient().putJson(this.getPropertiesPath(targetIdOrName, new String[0]), "{\"enabled\":true}");
    }

    public String getTargetId(String targetName) {
        Fragment f = this.getManageClient().getXml(this.getResourcesPath() + "/" + targetName, new String[0]);
        return f.getElementValue("/node()/db:id");
    }
}

