/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.Fragment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class PayloadParser {
    private ObjectMapper objectMapper;

    public JsonNode parseJson(String json) {
        if (this.objectMapper == null) {
            this.objectMapper = ObjectMapperFactory.getObjectMapper();
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to parse JSON: %s", e.getMessage()), e);
        }
    }

    public String getPayloadName(String payload, String idFieldName) {
        return this.getPayloadFieldValue(payload, idFieldName);
    }

    public String getPayloadFieldValue(String payload, String fieldName) {
        return this.getPayloadFieldValue(payload, fieldName, true);
    }

    public String getPayloadFieldValue(String payload, String fieldName, boolean throwErrorIfNotFound) {
        if (this.isJsonPayload(payload)) {
            JsonNode node = this.parseJson(payload);
            if (!node.has(fieldName)) {
                if (throwErrorIfNotFound) {
                    throw new RuntimeException("Cannot get field value from JSON; field name: " + fieldName + "; JSON: " + payload);
                }
                return null;
            }
            return node.get(fieldName).isTextual() ? node.get(fieldName).asText() : node.get(fieldName).toString();
        }
        Fragment f = new Fragment(payload, new Namespace[0]);
        String xpath = String.format("/node()/*[local-name(.) = '%s']", fieldName);
        if (!f.elementExists(xpath)) {
            if (throwErrorIfNotFound) {
                throw new RuntimeException("Cannot get field value from XML at path: " + xpath + "; XML: " + payload);
            }
            return null;
        }
        return f.getElementValues(xpath).get(0);
    }

    public boolean isJsonPayload(String payload) {
        if (payload == null) {
            return false;
        }
        String s = payload.trim();
        return s.startsWith("{") || s.startsWith("[");
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String includeProperties(String payload, String ... propertyNames) {
        List<String> propertyNameList = Arrays.asList(propertyNames);
        if (this.isJsonPayload(payload)) {
            JsonNode json = this.parseJson(payload);
            ObjectNode node = (ObjectNode)json;
            Iterator it = json.fieldNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (propertyNameList.contains(name)) continue;
                it.remove();
            }
            payload = node.toString();
        } else {
            Fragment frag = new Fragment(payload, new Namespace[0]);
            Element doc = frag.getInternalDoc().getRootElement();
            for (Element child : doc.getChildren()) {
                if (propertyNameList.contains(child.getName())) continue;
                child.detach();
            }
            payload = new XMLOutputter().outputString(doc);
        }
        return payload;
    }

    public String excludeProperties(String payload, String ... propertyNames) {
        if (this.isJsonPayload(payload)) {
            JsonNode json = this.parseJson(payload);
            for (String propertyName : propertyNames) {
                if (!json.has(propertyName)) continue;
                ObjectNode node = (ObjectNode)json;
                node.remove(propertyName);
            }
            payload = json.toString();
        } else {
            Fragment frag = new Fragment(payload, new Namespace[0]);
            Element doc = frag.getInternalDoc().getRootElement();
            for (String propertyName : propertyNames) {
                List<Element> elements = frag.getElements(propertyName);
                if (elements == null) continue;
                for (Element el : elements) {
                    el.detach();
                }
            }
            payload = new XMLOutputter().outputString(doc);
        }
        return payload;
    }
}

