/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.modules;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.DatabaseClient;

public class DeleteModulesCommand
extends AbstractCommand {
    private String pattern;
    private String databaseName;

    public DeleteModulesCommand() {
    }

    public DeleteModulesCommand(String pattern) {
        this();
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext context) {
        String dbName;
        if (this.pattern == null || this.pattern.trim().length() == 0) {
            this.logger.warn("No pattern was specified, so not deleting any modules");
        }
        AppConfig appConfig = context.getAppConfig();
        String string = dbName = this.databaseName != null ? this.databaseName : appConfig.getModulesDatabaseName();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deleting modules in database '%s' with URIs matching pattern '%s'", new Object[]{dbName, this.pattern}));
        }
        DatabaseClient client = appConfig.newAppServicesDatabaseClient(dbName);
        String xquery = "for $uri in cts:uri-match('%s') where fn:doc-available($uri) return xdmp:document-delete($uri)";
        try {
            client.newServerEval().xquery(this.format(xquery, new Object[]{this.pattern})).evalAs(String.class);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Finished deleting modules");
            }
        }
        finally {
            client.release();
        }
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

