/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.mimetypes;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.mimetypes.MimetypeManager;
import java.io.File;

public class DeployMimetypesCommand
extends AbstractResourceCommand {
    public DeployMimetypesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_MIMETYPES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_MIMETYPES);
        this.setRestartAfterDelete(true);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getMimetypesDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        MimetypeManager mgr = new MimetypeManager(context.getManageClient());
        if (context.getAppConfig().isUpdateMimetypeWhenPropertiesAreEqual()) {
            mgr.setUpdateWhenPropertiesAreEqual(true);
        } else {
            mgr.setUpdateWhenPropertiesAreEqual(false);
        }
        return mgr;
    }

    @Override
    protected void afterResourceSaved(ResourceManager mgr, CommandContext context, ResourceReference resourceReference, SaveReceipt receipt) {
        if (receipt != null && receipt.hasLocationHeader()) {
            this.logger.info("Waiting for restart after saving mimetype");
            context.getAdminManager().waitForRestart();
        }
    }
}

