/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.groups;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.server.AppServicesServer;
import com.marklogic.mgmt.api.server.ManageServer;
import com.marklogic.mgmt.api.server.Server;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.groups.GroupManager;
import java.io.File;

public class DeployGroupsCommand
extends AbstractResourceCommand {
    private Server adminServerTemplate;
    private Server manageServerTemplate;
    private Server appServicesServerTemplate;
    private boolean fixAdminServerRewriter = true;
    private boolean createManageServer = true;
    private boolean createAppServicesServer = true;

    public DeployGroupsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_GROUPS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_GROUPS);
        this.adminServerTemplate = new Server(null, "Admin");
        this.adminServerTemplate.setUrlRewriter("rewriter.xqy");
        this.manageServerTemplate = new ManageServer();
        this.appServicesServerTemplate = new AppServicesServer();
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getGroupsDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new GroupManager(context.getManageClient());
    }

    @Override
    protected void afterResourceSaved(ResourceManager mgr, CommandContext context, ResourceReference resourceReference, SaveReceipt receipt) {
        String payload = receipt.getPayload();
        if (payload != null && payload.contains("cache-size") && context.getAdminManager() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Group payload contains cache-size parameter, so waiting for ML to restart");
            }
            context.getAdminManager().waitForRestart();
        }
        if (receipt.hasLocationHeader()) {
            String groupName = new PayloadParser().getPayloadFieldValue(payload, "group-name", true);
            ServerManager serverMgr = new ServerManager(context.getManageClient(), groupName);
            if (this.fixAdminServerRewriter) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.format("Updating admin server in group %s to ensure that its url-rewriter is correct", new Object[]{groupName}));
                }
                serverMgr.save(this.adminServerTemplate.getJson());
            }
            this.ensureGroupServersExist(serverMgr, groupName);
        }
    }

    protected void ensureGroupServersExist(ServerManager serverMgr, String groupName) {
        if (this.createManageServer) {
            this.ensureServerExists(serverMgr, this.manageServerTemplate, groupName);
        }
        if (this.createAppServicesServer) {
            this.ensureServerExists(serverMgr, this.appServicesServerTemplate, groupName);
        }
    }

    protected void ensureServerExists(ServerManager serverMgr, Server server, String groupName) {
        String name = server.getServerName();
        if (serverMgr.exists(name, new String[0])) {
            this.logger.info(this.format("%s server already exists in group %s", new Object[]{name, groupName}));
        } else {
            server.setGroupName(groupName);
            serverMgr.save(server.getJson());
            this.logger.info(this.format("Created the %s server in group %s", new Object[]{name, groupName}));
        }
    }

    public Server getAdminServerTemplate() {
        return this.adminServerTemplate;
    }

    public void setAdminServerTemplate(Server adminServerTemplate) {
        this.adminServerTemplate = adminServerTemplate;
    }

    public Server getManageServerTemplate() {
        return this.manageServerTemplate;
    }

    public void setManageServerTemplate(Server manageServerTemplate) {
        this.manageServerTemplate = manageServerTemplate;
    }

    public Server getAppServicesServerTemplate() {
        return this.appServicesServerTemplate;
    }

    public void setAppServicesServerTemplate(Server appServicesServerTemplate) {
        this.appServicesServerTemplate = appServicesServerTemplate;
    }

    public boolean isFixAdminServerRewriter() {
        return this.fixAdminServerRewriter;
    }

    public void setFixAdminServerRewriter(boolean fixAdminServerRewriter) {
        this.fixAdminServerRewriter = fixAdminServerRewriter;
    }

    public boolean isCreateManageServer() {
        return this.createManageServer;
    }

    public void setCreateManageServer(boolean createManageServer) {
        this.createManageServer = createManageServer;
    }

    public boolean isCreateAppServicesServer() {
        return this.createAppServicesServer;
    }

    public void setCreateAppServicesServer(boolean createAppServicesServer) {
        this.createAppServicesServer = createAppServicesServer;
    }
}

