/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.forests.DefaultForestNamingStrategy;
import com.marklogic.appdeployer.command.forests.DistributedReplicaBuilderStrategy;
import com.marklogic.appdeployer.command.forests.ForestNamingStrategy;
import com.marklogic.appdeployer.command.forests.ForestPlan;
import com.marklogic.appdeployer.command.forests.ReplicaBuilderStrategy;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ForestBuilder
extends LoggingObject {
    private ForestNamingStrategy forestNamingStrategy;
    private ReplicaBuilderStrategy replicaBuilderStrategy;
    private ResourceMapper resourceMapper;

    public ForestBuilder() {
        this(new DefaultForestNamingStrategy());
    }

    public ForestBuilder(ForestNamingStrategy forestNamingStrategy) {
        this.forestNamingStrategy = forestNamingStrategy;
        this.replicaBuilderStrategy = new DistributedReplicaBuilderStrategy();
        this.resourceMapper = new DefaultResourceMapper(new API(null));
    }

    public List<Forest> buildForests(ForestPlan forestPlan, AppConfig appConfig) {
        String databaseName = forestPlan.getDatabaseName();
        Map<String, Map<String, List<Forest>>> existingForestsMap = this.existingForestsMap(forestPlan);
        int forestsPerDataDirectory = this.determineForestsPerDataDirectory(forestPlan, appConfig);
        List<String> dataDirectories = this.determineDataDirectories(databaseName, appConfig);
        ArrayList<Forest> forestsToBuild = new ArrayList<Forest>();
        int forestCounter = forestPlan.getExistingForests().size();
        for (String hostName : forestPlan.getHostNames()) {
            Map<String, List<Forest>> hostMap = existingForestsMap.get(hostName);
            for (String dataDirectory : dataDirectories) {
                int forestsToCreate = forestsPerDataDirectory;
                if (hostMap != null && hostMap.containsKey(dataDirectory)) {
                    forestsToCreate -= hostMap.get(dataDirectory).size();
                }
                for (int i = 0; i < forestsToCreate; ++i) {
                    Map<String, String> map;
                    Forest forest = this.newForest(forestPlan);
                    forest.setForestName(this.getForestName(databaseName, ++forestCounter, appConfig));
                    forest.setHost(hostName);
                    forest.setDatabase(databaseName);
                    if (dataDirectory != null && dataDirectory.trim().length() > 0) {
                        forest.setDataDirectory(dataDirectory);
                    }
                    if (appConfig.getForestFastDataDirectory() != null) {
                        forest.setFastDataDirectory(appConfig.getForestFastDataDirectory());
                    }
                    if (appConfig.getForestLargeDataDirectory() != null) {
                        forest.setLargeDataDirectory(appConfig.getForestLargeDataDirectory());
                    }
                    if ((map = appConfig.getDatabaseFastDataDirectories()) != null && map.containsKey(databaseName)) {
                        forest.setFastDataDirectory(map.get(databaseName));
                    }
                    if ((map = appConfig.getDatabaseLargeDataDirectories()) != null && map.containsKey(databaseName)) {
                        forest.setLargeDataDirectory(map.get(databaseName));
                    }
                    forestsToBuild.add(forest);
                }
            }
        }
        if (forestPlan.getReplicaCount() > 0) {
            this.addReplicasToForests(forestsToBuild, forestPlan, appConfig, dataDirectories);
        }
        return forestsToBuild;
    }

    protected Map<String, Map<String, List<Forest>>> existingForestsMap(ForestPlan forestPlan) {
        LinkedHashMap<String, Map<String, List<Forest>>> existingForestsMap = new LinkedHashMap<String, Map<String, List<Forest>>>();
        for (Forest f : forestPlan.getExistingForests()) {
            String host = f.getHost();
            String dataDirectory = f.getDataDirectory();
            if (dataDirectory == null) {
                dataDirectory = "";
            }
            Map dataDirectoryMap = existingForestsMap.computeIfAbsent(host, k -> new LinkedHashMap());
            List list = dataDirectoryMap.computeIfAbsent(dataDirectory, k -> new ArrayList());
            list.add(f);
        }
        return existingForestsMap;
    }

    public void addReplicasToForests(List<Forest> forests, ForestPlan forestPlan, AppConfig appConfig, List<String> dataDirectories) {
        String databaseName = forestPlan.getDatabaseName();
        List<String> hostNames = forestPlan.getReplicaHostNames();
        int replicaCount = forestPlan.getReplicaCount();
        if (replicaCount >= hostNames.size()) {
            throw new IllegalArgumentException(String.format("Not enough hosts exists to create %d replicas for database '%s'; possible hosts, which may include the host with the primary forest and thus cannot have a replica: %s", replicaCount, databaseName, hostNames));
        }
        List<String> replicaDataDirectories = this.determineReplicaDataDirectories(forestPlan, appConfig);
        if (replicaDataDirectories == null) {
            replicaDataDirectories = dataDirectories;
        }
        ReplicaBuilderStrategy strategyToUse = this.replicaBuilderStrategy;
        if (appConfig.getReplicaBuilderStrategy() != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using ReplicaBuilderStrategy defined in AppConfig");
            }
            strategyToUse = appConfig.getReplicaBuilderStrategy();
        }
        strategyToUse.buildReplicas(forests, forestPlan, appConfig, replicaDataDirectories, this.determineForestNamingStrategy(databaseName, appConfig));
    }

    protected Forest newForest(ForestPlan forestPlan) {
        String template = forestPlan.getTemplate();
        if (template == null) {
            return new Forest();
        }
        try {
            return this.resourceMapper.readResource(template, Forest.class);
        }
        catch (Exception ex) {
            this.logger.warn("Unable to construct a new Forest using template: " + template, (Throwable)ex);
            return new Forest();
        }
    }

    protected List<String> determineDataDirectories(String databaseName, AppConfig appConfig) {
        List<String> dataDirectories = null;
        if (appConfig.getDatabaseDataDirectories() != null) {
            dataDirectories = appConfig.getDatabaseDataDirectories().get(databaseName);
        }
        if (dataDirectories == null || dataDirectories.isEmpty()) {
            dataDirectories = new ArrayList<String>();
            if (appConfig.getForestDataDirectory() != null) {
                dataDirectories.add(appConfig.getForestDataDirectory());
            } else {
                dataDirectories.add("");
            }
        }
        return dataDirectories;
    }

    protected List<String> determineReplicaDataDirectories(ForestPlan forestPlan, AppConfig appConfig) {
        ArrayList<String> replicaDataDirectories = null;
        if (appConfig.getReplicaForestDataDirectory() != null) {
            replicaDataDirectories = new ArrayList<String>();
            replicaDataDirectories.add(appConfig.getReplicaForestDataDirectory());
        }
        Map<String, List<String>> replicaDataDirectoryMap = appConfig.getDatabaseReplicaDataDirectories();
        String databaseName = forestPlan.getDatabaseName();
        if (replicaDataDirectoryMap != null && replicaDataDirectoryMap.containsKey(databaseName)) {
            replicaDataDirectories = new ArrayList(replicaDataDirectoryMap.get(databaseName));
        }
        return replicaDataDirectories;
    }

    protected int determineForestsPerDataDirectory(ForestPlan forestPlan, AppConfig appConfig) {
        Integer i;
        int forestCount = forestPlan.getForestsPerDataDirectory();
        Map<String, Integer> forestCounts = appConfig.getForestCounts();
        if (forestCounts != null && forestCounts.containsKey(forestPlan.getDatabaseName()) && (i = forestCounts.get(forestPlan.getDatabaseName())) != null) {
            forestCount = i;
        }
        return forestCount;
    }

    protected String getForestName(String databaseName, int forestNumber, AppConfig appConfig) {
        return this.determineForestNamingStrategy(databaseName, appConfig).getForestName(databaseName, forestNumber, appConfig);
    }

    protected ForestNamingStrategy determineForestNamingStrategy(String databaseName, AppConfig appConfig) {
        ForestNamingStrategy fns = null;
        Map<String, ForestNamingStrategy> map = appConfig.getForestNamingStrategies();
        if (map != null) {
            fns = map.get(databaseName);
        }
        return fns != null ? fns : this.forestNamingStrategy;
    }

    public void setReplicaBuilderStrategy(ReplicaBuilderStrategy replicaBuilderStrategy) {
        this.replicaBuilderStrategy = replicaBuilderStrategy;
    }

    public ReplicaBuilderStrategy getReplicaBuilderStrategy() {
        return this.replicaBuilderStrategy;
    }

    public ForestNamingStrategy getForestNamingStrategy() {
        return this.forestNamingStrategy;
    }
}

