/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.forests.ForestBuilder;
import com.marklogic.appdeployer.command.forests.ForestPlan;
import com.marklogic.appdeployer.command.forests.GroupHostNamesProvider;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.mgmt.resource.forests.ForestStatus;
import com.marklogic.mgmt.resource.groups.GroupManager;
import com.marklogic.mgmt.resource.hosts.HostManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigureForestReplicasCommand
extends AbstractUndoableCommand {
    private Map<String, Integer> databaseNamesAndReplicaCounts = new HashMap<String, Integer>();
    private boolean deleteReplicasOnUndo = true;
    private GroupHostNamesProvider groupHostNamesProvider;

    public ConfigureForestReplicasCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FOREST_REPLICAS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_FOREST_REPLICAS);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.getAppConfig().getDatabaseNamesAndReplicaCounts() != null) {
            this.databaseNamesAndReplicaCounts = context.getAppConfig().getDatabaseNamesAndReplicaCounts();
        }
        if (this.databaseNamesAndReplicaCounts == null || this.databaseNamesAndReplicaCounts.isEmpty()) {
            this.logger.info("No database names and replica counts defined, so not configuring any forest replicas");
            return;
        }
        List<String> hostNames = new HostManager(context.getManageClient()).getHostNames();
        if (hostNames.size() < 2) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Only found one host, so not configuring any replica forests; host: " + hostNames.get(0));
            }
            return;
        }
        for (String databaseName : this.databaseNamesAndReplicaCounts.keySet()) {
            int replicaCount = this.databaseNamesAndReplicaCounts.get(databaseName);
            if (replicaCount <= 0) continue;
            this.configureDatabaseReplicaForests(databaseName, replicaCount, hostNames, context);
        }
    }

    @Override
    public void undo(CommandContext context) {
        if (this.deleteReplicasOnUndo) {
            if (context.getAppConfig().getDatabaseNamesAndReplicaCounts() != null) {
                this.setDatabaseNamesAndReplicaCounts(context.getAppConfig().getDatabaseNamesAndReplicaCounts());
            }
            DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
            ForestManager forestMgr = new ForestManager(context.getManageClient());
            for (String databaseName : this.databaseNamesAndReplicaCounts.keySet()) {
                this.logger.info(this.format("Deleting forest replicas for database %s", new Object[]{databaseName}));
                if (!dbMgr.exists(databaseName, new String[0])) {
                    this.logger.warn(this.format("Database %s does not exist, so not able to delete forest replica for it; perhaps a previous command deleted the database?", new Object[]{databaseName}));
                    continue;
                }
                List<String> forestNames = dbMgr.getForestNames(databaseName);
                for (String forestName : forestNames) {
                    this.deleteReplicas(forestName, forestMgr);
                }
                this.logger.info(this.format("Finished deleting forest replicas for database %s", new Object[]{databaseName}));
            }
        } else {
            this.logger.info("deleteReplicasOnUndo is set to false, so not deleting any replicas");
        }
    }

    protected void deleteReplicas(String forestName, ForestManager forestMgr) {
        ForestStatus status;
        if (forestMgr.exists(forestName, new String[0]) && (status = forestMgr.getForestStatus(forestName)).isPrimary() && status.hasReplicas()) {
            this.logger.info(this.format("Deleting forest replicas for primary forest %s", new Object[]{forestName}));
            forestMgr.deleteReplicas(forestName);
            this.logger.info(this.format("Finished deleting forest replicas for primary forest %s", new Object[]{forestName}));
        }
    }

    protected void configureDatabaseReplicaForests(String databaseName, int replicaCount, List<String> hostNames, CommandContext context) {
        List<Forest> forestsNeedingReplicas = this.determineForestsNeedingReplicas(databaseName, context);
        ForestBuilder forestBuilder = new ForestBuilder();
        List<String> selectedHostNames = this.getHostNamesForDatabaseForests(databaseName, hostNames, context);
        ForestPlan forestPlan = new ForestPlan(databaseName, selectedHostNames).withReplicaCount(replicaCount);
        List<String> dataDirectories = forestBuilder.determineDataDirectories(databaseName, context.getAppConfig());
        forestBuilder.addReplicasToForests(forestsNeedingReplicas, forestPlan, context.getAppConfig(), dataDirectories);
        List<Forest> forestsWithOnlyReplicas = forestsNeedingReplicas.stream().map(forest -> {
            Forest forestWithOnlyReplicas = new Forest();
            forestWithOnlyReplicas.setForestName(forest.getForestName());
            forestWithOnlyReplicas.setForestReplica(forest.getForestReplica());
            return forestWithOnlyReplicas;
        }).collect(Collectors.toList());
        if (context.getAppConfig().getCmaConfig().isDeployForests()) {
            try {
                Configuration config = new Configuration();
                forestsWithOnlyReplicas.forEach(forest -> config.addForest(forest.toObjectNode()));
                new Configurations(config).submit(context.getManageClient());
                return;
            }
            catch (Exception ex) {
                this.logger.warn("Unable to create forest replicas via CMA; cause: " + ex.getMessage() + "; will fall back to using /manage/v2.");
            }
        }
        ForestManager forestManager = new ForestManager(context.getManageClient());
        forestsWithOnlyReplicas.forEach(forest -> {
            String forestName = forest.getForestName();
            this.logger.info(this.format("Creating forest replicas for primary forest %s", new Object[]{forestName}));
            context.getManageClient().putJson(forestManager.getPropertiesPath(forestName, new String[0]), forest.getJson());
            this.logger.info(this.format("Finished creating forest replicas for primary forest %s", new Object[]{forestName}));
        });
    }

    protected List<Forest> determineForestsNeedingReplicas(String databaseName, CommandContext context) {
        ForestManager forestManager = new ForestManager(context.getManageClient());
        DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
        API api = new API(context.getManageClient());
        DefaultResourceMapper resourceMapper = new DefaultResourceMapper(api);
        ArrayList<Forest> forestsNeedingReplicas = new ArrayList<Forest>();
        Map<String, List<Forest>> mapOfPrimaryForests = context.getMapOfPrimaryForests();
        if (mapOfPrimaryForests != null && mapOfPrimaryForests.containsKey(databaseName)) {
            mapOfPrimaryForests.get(databaseName).forEach(forest -> {
                boolean forestHasReplicasAlready;
                boolean bl = forestHasReplicasAlready = forest.getForestReplica() != null && !forest.getForestReplica().isEmpty();
                if (!forestHasReplicasAlready) {
                    forestsNeedingReplicas.add((Forest)forest);
                }
            });
        } else {
            for (String forestName : dbMgr.getForestNames(databaseName)) {
                this.logger.info(this.format("Checking the status of forest %s to determine if it is a primary forest and whether or not it has replicas already.", new Object[]{forestName}));
                ForestStatus status = forestManager.getForestStatus(forestName);
                if (!status.isPrimary()) {
                    this.logger.info(this.format("Forest %s is not a primary forest, so not configuring replica forests", new Object[]{forestName}));
                    continue;
                }
                if (status.hasReplicas()) {
                    this.logger.info(this.format("Forest %s already has replicas, so not configuring replica forests", new Object[]{forestName}));
                    continue;
                }
                String forestJson = forestManager.getPropertiesAsJson(forestName, new String[0]);
                Forest forest2 = resourceMapper.readResource(forestJson, Forest.class);
                forestsNeedingReplicas.add(forest2);
            }
        }
        return forestsNeedingReplicas;
    }

    protected List<String> getHostNamesForDatabaseForests(String databaseName, List<String> hostNames, CommandContext context) {
        List<String> databaseHosts;
        ArrayList<String> selectedHostNames = new ArrayList<String>();
        Map<String, List<String>> databaseGroupMap = context.getAppConfig().getDatabaseGroups();
        List<String> databaseGroups = databaseGroupMap != null ? databaseGroupMap.get(databaseName) : null;
        Map<String, List<String>> databaseHostMap = context.getAppConfig().getDatabaseHosts();
        List<String> list = databaseHosts = databaseHostMap != null ? databaseHostMap.get(databaseName) : null;
        if (databaseGroups != null && !databaseGroups.isEmpty()) {
            if (this.groupHostNamesProvider == null) {
                this.groupHostNamesProvider = groupName -> new GroupManager(context.getManageClient()).getHostNames(groupName);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating replica forests on hosts in groups %s for database '%s'", new Object[]{databaseGroups, databaseName}));
            }
            for (String groupName2 : databaseGroups) {
                List<String> groupHostNames = this.groupHostNamesProvider.getGroupHostNames(groupName2);
                if (groupHostNames == null || groupHostNames.isEmpty()) {
                    this.logger.warn("No hosts found for group: " + groupName2);
                    continue;
                }
                for (String hostName : hostNames) {
                    if (!groupHostNames.contains(hostName)) continue;
                    selectedHostNames.add(hostName);
                }
            }
            if (!selectedHostNames.isEmpty()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.format("Creating forests on hosts %s based on groups %s for database '%s'", new Object[]{selectedHostNames, databaseGroups, databaseName}));
                }
                if (databaseHosts != null && !databaseHosts.isEmpty()) {
                    this.logger.warn(this.format("Database groups and database hosts were both specified for database '%s'; only database groups are being used, database hosts will be ignored.", new Object[]{databaseName}));
                }
                return selectedHostNames;
            }
            this.logger.warn("Did not find any valid hosts in selected groups: " + databaseGroups);
        }
        for (String hostName : hostNames) {
            if (databaseHosts != null && !databaseHosts.contains(hostName)) continue;
            selectedHostNames.add(hostName);
        }
        return selectedHostNames;
    }

    public void setDeleteReplicasOnUndo(boolean deleteReplicasOnUndo) {
        this.deleteReplicasOnUndo = deleteReplicasOnUndo;
    }

    public Map<String, Integer> getDatabaseNamesAndReplicaCounts() {
        return this.databaseNamesAndReplicaCounts;
    }

    public void setDatabaseNamesAndReplicaCounts(Map<String, Integer> databaseNamesAndReplicaCounts) {
        this.databaseNamesAndReplicaCounts = databaseNamesAndReplicaCounts;
    }

    public void setGroupHostNamesProvider(GroupHostNamesProvider groupHostNamesProvider) {
        this.groupHostNamesProvider = groupHostNamesProvider;
    }
}

