/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.data;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.DataConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.FileLoader;
import com.marklogic.client.ext.file.GenericFileLoader;
import java.util.List;
import org.springframework.util.StringUtils;

public class LoadDataCommand
extends AbstractCommand {
    public LoadDataCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_DATA);
    }

    @Override
    public void execute(CommandContext context) {
        DataConfig dataConfig = context.getAppConfig().getDataConfig();
        if (dataConfig == null) {
            return;
        }
        if (!dataConfig.isDataLoadingEnabled()) {
            this.logger.info("Data loading is disabled");
            return;
        }
        List<String> dataPaths = dataConfig.getDataPaths();
        if (dataPaths == null || dataPaths.isEmpty()) {
            return;
        }
        FileLoader fileLoader = this.buildFileLoader(context.getAppConfig());
        for (String dataPath : dataPaths) {
            fileLoader.loadFiles(new String[]{dataPath});
        }
    }

    protected FileLoader buildFileLoader(AppConfig appConfig) {
        DatabaseClient client = this.determineDatabaseClient(appConfig);
        GenericFileLoader loader = new GenericFileLoader(client);
        loader.setCascadeCollections(appConfig.isCascadeCollections());
        loader.setCascadePermissions(appConfig.isCascadePermissions());
        DataConfig dataConfig = appConfig.getDataConfig();
        Integer batchSize = dataConfig.getBatchSize();
        if (batchSize != null) {
            this.logger.info("Loading data in batches of size: " + batchSize);
            loader.setBatchSize(batchSize);
        }
        if (dataConfig.isReplaceTokensInData()) {
            loader.setTokenReplacer(appConfig.buildTokenReplacer());
        }
        loader.setAdditionalBinaryExtensions(appConfig.getAdditionalBinaryExtensions());
        loader.setPermissions(dataConfig.getPermissions());
        if (dataConfig.getFileFilter() != null) {
            loader.addFileFilter(dataConfig.getFileFilter());
        }
        if (dataConfig.getCollections() != null) {
            loader.setCollections(dataConfig.getCollections());
        }
        loader.setLogFileUris(dataConfig.isLogUris());
        return loader;
    }

    protected DatabaseClient determineDatabaseClient(AppConfig appConfig) {
        DataConfig dataConfig = appConfig.getDataConfig();
        String databaseName = dataConfig.getDatabaseName();
        if (StringUtils.hasText((String)databaseName)) {
            this.logger.info("Will load data via App-Services port into database: " + databaseName);
            return appConfig.newAppServicesDatabaseClient(databaseName);
        }
        return appConfig.newDatabaseClient();
    }
}

