/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.cma;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.cma.ConfigurationManager;
import java.io.File;

public class DeployConfigurationsCommand
extends AbstractCommand {
    @Override
    public void execute(CommandContext context) {
        ConfigurationManager mgr = new ConfigurationManager(context.getManageClient());
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dir = configDir.getConfigurationsDir();
            if (dir != null && dir.exists()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Processing files in directory: " + dir.getAbsolutePath());
                }
                for (File f : super.listFilesInDirectory(dir)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Processing file: " + f.getAbsolutePath());
                    }
                    String payload = this.readResourceFromFile(context, f);
                    SaveReceipt receipt = mgr.save(payload);
                    this.afterResourceSaved(null, context, new ResourceReference(f, null), receipt);
                }
                continue;
            }
            this.logResourceDirectoryNotFound(dir);
        }
    }
}

