/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.appservers;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import java.io.File;

public class UpdateRestApiServersCommand
extends AbstractCommand {
    private String restApiFilename;

    public UpdateRestApiServersCommand() {
        this.setExecuteSortOrder(SortOrderConstants.UPDATE_REST_API_SERVERS);
    }

    public UpdateRestApiServersCommand(String restApiFilename) {
        this();
        this.restApiFilename = restApiFilename;
    }

    @Override
    public void execute(CommandContext context) {
        File f = this.findRestApiConfigFile(context);
        if (f != null && f.exists()) {
            AppConfig appConfig = context.getAppConfig();
            ServerManager mgr = new ServerManager(context.getManageClient(), appConfig.getGroupName());
            this.saveResource((ResourceManager)mgr, context, f);
            if (appConfig.isTestPortSet()) {
                String payload = this.copyFileToString(f);
                payload = this.payloadTokenReplacer.replaceTokens(payload, appConfig, true);
                payload = this.adjustPayloadBeforeSavingResource(context, f, payload);
                mgr.save(payload);
            }
        }
    }

    protected File findRestApiConfigFile(CommandContext context) {
        if (this.restApiFilename != null) {
            File f = null;
            for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                File tmpFile = new File(configDir.getBaseDir(), this.restApiFilename);
                if (!tmpFile.exists()) continue;
                f = tmpFile;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Found REST API configuration file at: " + f.getAbsolutePath());
                    continue;
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Did not find REST API configuration file at: " + tmpFile.getAbsolutePath());
            }
            return f;
        }
        File f = null;
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File tmpFile = configDir.getRestApiServerFile();
            if (tmpFile.exists()) {
                f = tmpFile;
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Found REST API configuration file at: " + f.getAbsolutePath());
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Did not find REST API configuration file at: " + tmpFile.getAbsolutePath());
        }
        return f;
    }
}

