/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.resource.forests.ForestManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private AppConfig appConfig;
    private ManageClient manageClient;
    private AdminManager adminManager;
    private Map<String, Object> contextMap;
    private static final String COMBINED_CMA_REQUEST_KEY = "cma-combined-request";

    public CommandContext(AppConfig appConfig, ManageClient manageClient, AdminManager adminManager) {
        this.appConfig = appConfig;
        this.manageClient = manageClient;
        this.adminManager = adminManager;
        this.contextMap = new HashMap<String, Object>();
    }

    public void addCmaConfigurationToCombinedRequest(Configuration configuration) {
        Configurations configs = this.getCombinedCmaRequest();
        if (configs == null) {
            this.contextMap.put(COMBINED_CMA_REQUEST_KEY, new Configurations(configuration));
        } else {
            configs.addConfig(configuration);
        }
    }

    public Map<String, List<Forest>> getMapOfPrimaryForests() {
        if (!this.appConfig.getCmaConfig().isDeployForests()) {
            return null;
        }
        String key = "ml-app-deployer-mapOfPrimaryForests";
        if (this.contextMap.containsKey("ml-app-deployer-mapOfPrimaryForests")) {
            return (Map)this.contextMap.get("ml-app-deployer-mapOfPrimaryForests");
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            logger.info("Retrieving all forest details via CMA");
            long start = System.currentTimeMillis();
            Map<String, List<Forest>> mapOfPrimaryForests = new ForestManager(this.manageClient).getMapOfPrimaryForests();
            logger.info("Finished retrieving all forests details via CMA; duration: " + (System.currentTimeMillis() - start));
            this.contextMap.put("ml-app-deployer-mapOfPrimaryForests", mapOfPrimaryForests);
            return mapOfPrimaryForests;
        }
        catch (Exception ex) {
            logger.warn("Unable to retrieve all forest details, cause: " + ex.getMessage() + "; will fall back to using /manage/v2 when needed for getting details for a forest.");
            return null;
        }
    }

    public Configurations getCombinedCmaRequest() {
        return (Configurations)this.contextMap.get(COMBINED_CMA_REQUEST_KEY);
    }

    public void removeCombinedCmaRequest() {
        this.contextMap.remove(COMBINED_CMA_REQUEST_KEY);
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    @Deprecated
    public void setContextMap(Map<String, Object> contextMap) {
        this.contextMap = contextMap;
    }
}

