/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

import com.marklogic.xcc.exceptions.UnexpectedResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpHeaders {
    private static final String PREFIX = "X-X-";
    private static final String HTTP_RESPONSE_KEY = "X-X-HTTP-RESPONSE-LINE";
    private static final String RESPONSE_CODE_KEY = "X-X-HTTP-RESPONSE-CODE";
    private static final String RESPONSE_MSG_KEY = "X-X-HTTP-RESPONSE-MESSAGE";
    private static final String HTTP_REQUEST_KEY = "X-X-HTTP-REQUEST-LINE";
    private static final String REQUEST_METHOD_KEY = "X-X-HTTP-REQUEST-METHOD";
    private static final String REQUEST_PATH_KEY = "X-X-HTTP-REQUEST-PATH";
    private static final String REQUEST_VERSION_KEY = "X-X-HTTP-REQUEST-VERSION";
    private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

    public void clear() {
        this.headers.clear();
    }

    public int size() {
        return this.headers.size();
    }

    public void setHeaderNormalized(String name, String value) {
        this.setHeader(name.toLowerCase(), value);
    }

    public void setHeader(String name, String value) {
        List<String> l = this.headers.get(name);
        if (l == null) {
            l = new LinkedList<String>();
            this.headers.put(name, l);
        }
        l.add(value);
    }

    public List<String> getAllHeadersNormalized(String name) {
        return this.getAllHeaders(name.toLowerCase());
    }

    public List<String> getAllHeaders(String name) {
        List<String> vals = this.headers.get(name);
        return vals == null ? null : Collections.unmodifiableList(vals);
    }

    public String getHeaderNormalized(String name) {
        return this.getHeader(name.toLowerCase());
    }

    public String getHeader(String name) {
        List<String> vals = this.headers.get(name);
        return vals == null ? null : vals.get(vals.size() - 1);
    }

    public Iterator<String> iterator() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.headers.size());
        for (String key : this.headers.keySet()) {
            if (key.startsWith(PREFIX)) continue;
            keys.add(key);
        }
        return keys.iterator();
    }

    public Iterator<String> iteratorAll() {
        return Collections.unmodifiableMap(this.headers).keySet().iterator();
    }

    public void setResponseValues(String line) throws IOException {
        this.setHeader(HTTP_RESPONSE_KEY, line);
        String[] parts = line.split("\\s+", 3);
        if (parts.length < 2 || !parts[0].startsWith("HTTP/1.") && !parts[0].startsWith("XDBC/")) {
            throw new IOException("Malformed Response: " + line);
        }
        String codeStr = parts[1];
        try {
            Integer.parseInt(codeStr);
            this.setHeader(RESPONSE_CODE_KEY, codeStr);
        }
        catch (NumberFormatException e) {
            throw new IOException("Malformed Response code: " + codeStr);
        }
        String msg = parts.length > 2 ? parts[2] : "";
        this.setHeader(RESPONSE_MSG_KEY, msg);
    }

    public String getResponseLine() {
        return this.getHeader(HTTP_RESPONSE_KEY);
    }

    public int getResponseCode() {
        String hdr = this.getHeader(RESPONSE_CODE_KEY);
        if (hdr == null) {
            return -1;
        }
        return Integer.parseInt(hdr);
    }

    public String getResponseMessage() {
        return this.getHeader(RESPONSE_MSG_KEY);
    }

    public void setRequestValues(String method, String path, String version) {
        this.setHeader(REQUEST_METHOD_KEY, method);
        this.setHeader(REQUEST_PATH_KEY, path);
        this.setHeader(REQUEST_VERSION_KEY, version);
        this.setHeader(HTTP_REQUEST_KEY, method + " " + path + " " + version);
    }

    public String getRequestLine() {
        return this.getHeader(HTTP_REQUEST_KEY);
    }

    public String getRequestMethod() {
        return this.getHeader(REQUEST_METHOD_KEY);
    }

    public String getRequestPath() {
        return this.getHeader(REQUEST_PATH_KEY);
    }

    public String getRequestVersion() {
        return this.getHeader(REQUEST_VERSION_KEY);
    }

    public int getContentLength() {
        String lengthStr = this.getHeaderNormalized("content-length");
        if (lengthStr == null) {
            return -1;
        }
        try {
            return Integer.parseInt(lengthStr);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getContentType() {
        String value = this.getHeaderNormalized("content-type");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("\\s*;\\s*");
        return parts[0];
    }

    public String getContentTypeField(String fieldName) {
        return this.getHeaderSubValue("content-type", fieldName, ";");
    }

    public boolean isChunked() {
        String transferStr = this.getHeaderNormalized("transfer-encoding");
        return "chunked".equals(transferStr);
    }

    public String getResponseConnection() {
        return this.getHeaderNormalized("connection");
    }

    public StringBuffer toStringBuffer(StringBuffer userSb) {
        StringBuffer sb = userSb == null ? new StringBuffer(1024) : userSb;
        String lineSep = "\r\n";
        sb.append(this.getRequestLine());
        sb.append(lineSep);
        Iterator<String> it = this.iterator();
        while (it.hasNext()) {
            String key = it.next();
            for (String val : this.getAllHeaders(key)) {
                sb.append(key).append(": ").append(val);
                sb.append(lineSep);
            }
        }
        sb.append(lineSep);
        return sb;
    }

    public String toString() {
        return this.toStringBuffer(null).toString();
    }

    public int writeHeaders(OutputStream os) throws IOException {
        byte[] bytes = this.toString().getBytes("UTF-8");
        os.write(bytes);
        return bytes.length;
    }

    public void parseResponseHeaders(InputStream is) throws IOException {
        String line;
        this.clear();
        try {
            line = this.nextHeaderLine(is);
        }
        catch (Exception e) {
            IOException newex = new IOException("Error parsing HTTP headers: " + e.getMessage(), e);
            newex.setStackTrace(e.getStackTrace());
            throw newex;
        }
        this.setResponseValues(line);
        this.parsePlainHeaders(is);
    }

    public void parsePlainHeaders(InputStream is) throws IOException {
        try {
            String line;
            while ((line = this.nextHeaderLine(is)) != null) {
                int i = line.indexOf(58);
                if (i != -1) {
                    this.setHeaderNormalized(line.substring(0, i), line.substring(i + 2));
                    continue;
                }
                throw new IOException("Malformed header line: " + line);
            }
        }
        catch (Exception e) {
            IOException newex = new IOException("Error parsing HTTP headers: " + e.getMessage(), e);
            throw newex;
        }
    }

    private String nextHeaderLine(InputStream is) throws UnexpectedResponseException, IOException {
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            int b;
            if ((b = is.read()) == -1) {
                throw new UnexpectedResponseException("Premature EOF, partial header line read: '" + sb.toString() + "'", sb.toString());
            }
            if (b == 13) continue;
            if (b == 10) break;
            sb.append((char)b);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public String getHeaderSubValue(String headerName, String subName, String delim) {
        List<String> values = this.getAllHeaders(headerName);
        if (values != null) {
            for (String header : values) {
                String val = HttpHeaders.getHeaderSubValueFromValue(header, subName, delim);
                if (val == null) continue;
                return val;
            }
        }
        return null;
    }

    public static String getHeaderSubValueFromValue(String headerValue, String subName, String delim) {
        if (headerValue == null) {
            return null;
        }
        String[] parts = headerValue.split("\\s*" + delim + "\\s*");
        for (int i = 0; i < parts.length; ++i) {
            String[] subParts;
            String part = parts[i];
            if (!part.startsWith(subName) || (subParts = part.split("\\s*=\\s*")).length != 2) continue;
            return subParts[1];
        }
        return null;
    }

    public Integer getHeaderSubValueInt(String headerName, String subName, String delim) {
        String strValue = this.getHeaderSubValue(headerName, subName, delim);
        if (strValue == null) {
            return null;
        }
        try {
            return Integer.decode(strValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static String extractCsvSubValue(String csv, String subName) {
        String[] parts = csv.split("\\s*,\\s*");
        for (int i = 0; i < parts.length; ++i) {
            String[] subParts;
            String part = parts[i];
            if (!part.startsWith(subName) || (subParts = part.split("\\s*=\\s*")).length != 2) continue;
            return subParts[1];
        }
        return null;
    }

    static Integer extractCsvIntSubValue(String csv, String subName) {
        String subString = HttpHeaders.extractCsvSubValue(csv, subName);
        if (subString == null) {
            return null;
        }
        try {
            return Integer.decode(subString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

