/*
 * Copyright (c) 2023 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.xcc.exceptions;

import com.marklogic.xcc.Request;

/**
 * This is the base class for exceptions originating in the server (XQuery syntax errors, etc)
 * as opposed exceptions related to communicating with the server.
 */
public class RequestServerException extends RequestException {
    private static final long serialVersionUID = 5878916853339528551L;

    public RequestServerException(String message, Request request) {
        this(message, request, false);
    }

    public RequestServerException(String message, Request request, Throwable cause) {
        this(message, request, cause, false);
    }

    public RequestServerException(String message, Request request,
      boolean isRetryable) {
        super(message, request, isRetryable);
    }

    public RequestServerException(String message, Request request,
      Throwable cause, boolean isRetryable) {
        super(message, request, cause, isRetryable);
    }
}
