/*
 * Copyright (c) 2023 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.xcc.exceptions;

import com.marklogic.xcc.Request;

/**
 * This exception indicates a problem related to MarkLogic Cloud.
 */
public class MLCloudRequestException extends RequestException {
    private static final long serialVersionUID = 8716170183779280389L;

    /**
     * Constructs an MLCloudRequestException
     * @param message The exception message
     * @param request The {@link com.marklogic.xcc.Request} object to which this exception applies
     * @param isRetryable Retrying the operation may succeed
     */
    public MLCloudRequestException(String message, Request request,
                                   boolean isRetryable) {
        super(message, request, isRetryable);
    }

    /**
     * Constructs an MLCloudRequestException
     * @param message The exception message
     * @param request The {@link com.marklogic.xcc.Request} object to which this exception applies
     * @param cause The {@link java.lang.Throwable} object which is the cause of this exception
     * @param isRetryable Retrying the operation may succeed
     */
    public MLCloudRequestException(String message, Request request,
        Throwable cause, boolean isRetryable) {
        super(message, request, cause, isRetryable);
    }
}
