/**
  Copyright (c) 2021 MarkLogic Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
// must keep as sjs to be compatible with MLCP, otherwise we get the following error: XDMP-NOEXECUTE: var xform = require(transformModule)[transformFunction]; -- Document is not of executable mimetype. URI: /data-hub/5/transforms/mlcp-flow-transform.mjs
// also, emptySequence is declared prior to mjsProxy so type checking by MLCP isn't corrupted
const emptySequence = Sequence.from([]);
// This looks for the entire list of URIs in an MLCP batch
const urisInBatch = xdmp.getRequestFieldNames().toArray()
  .filter((requestField) => xdmp.getRequestField(requestField) === "URI")
  .map((requestField) => xdmp.getRequestField(fn.replace(requestField, "^evl", "evv")));
const urisToContent = {};

function normalizeContext(context) {
  for (let [key, value] of Object.entries(context)) {
    if (value && value[Symbol.iterator]) {
      context[key] = (key === "quality") ? fn.head(value) : [...value];
    }
  }
  return context;
}

function transform(originalContent, originalContext = {}) {
  let contentUri = originalContent.uri;
  urisToContent[contentUri] = originalContent;
  // Only call DH flow once per MLCP batch
  let everyContentItemVisited = urisInBatch.every(uri => !!urisToContent[uri]);
  if (everyContentItemVisited) {
    let {content, context} = fn.head(xdmp.invoke("/data-hub/transforms/mlcp-flow-invoke.mjs", {urisToContent, context: originalContext, permissionType: "object"}));
    // This is a workaround so MLCP will recognize a Sequence from MJS
    Object.apply(originalContent, normalizeContext(context));
    content = content && content[Symbol.iterator] ? [...content]: [content];
    return Sequence.from(content);
  } else {
    return emptySequence;
  }
}



module.exports = {transform};
