/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.marklogic.hub.HubClientConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DiskQueue<E extends Serializable>
extends AbstractQueue<String>
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DiskQueue.class.getName());
    private static final float DEFAULT_REFILL_RATIO = 0.75f;
    final MemoryQueue<String> memoryQueue;
    Iterator<String> memoryIterator;
    private final float refillMemoryRatio;
    int fileElementCount = 0;
    private final File tempDir;
    private BufferedWriter fileOut;
    private BufferedReader fileIn;
    String cachedElement;
    private File fileQueue;

    private static int safeIntCast(float f) {
        if (f > 2.1474836E9f) {
            return 0x7FFFFFFE;
        }
        return (int)f;
    }

    public DiskQueue(HubClientConfig hubClientConfig) {
        File tempDir;
        int maxStringsInMemory = hubClientConfig.getMaxStringsInMemory() != 0 ? hubClientConfig.getMaxStringsInMemory() : DiskQueue.safeIntCast((float)Runtime.getRuntime().freeMemory() / 130.0f * 0.75f);
        File file = tempDir = StringUtils.isEmpty((CharSequence)hubClientConfig.getCollectorTmpDir()) ? null : new File(hubClientConfig.getCollectorTmpDir());
        if (maxStringsInMemory < 1) {
            throw new InvalidParameterException(DiskQueue.class.getSimpleName() + " max in-memory size must be at least one");
        }
        if (!(tempDir == null || tempDir.exists() && tempDir.isDirectory() && tempDir.canWrite())) {
            throw new InvalidParameterException(DiskQueue.class.getSimpleName() + " temporary directory must exist and be writable");
        }
        this.tempDir = tempDir;
        this.memoryQueue = new MemoryQueue(maxStringsInMemory);
        this.refillMemoryRatio = 0.75f;
    }

    @Override
    public void close() {
        if (this.closeFile()) {
            LOG.warning(MessageFormat.format("{0} still had open file", DiskQueue.class.getSimpleName()));
        }
    }

    private boolean closeFile() {
        if (this.fileQueue == null) {
            return false;
        }
        DiskQueue.closeQuietly(this.fileIn);
        this.fileIn = null;
        this.cachedElement = null;
        DiskQueue.closeQuietly(this.fileOut);
        this.fileOut = null;
        this.fileElementCount = 0;
        if (!this.fileQueue.delete()) {
            LOG.log(Level.INFO, "Unable to clean up file queue located at " + this.fileQueue.getAbsolutePath());
        }
        this.fileQueue = null;
        return true;
    }

    private static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    private static void closeQuietly(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void openFile() throws IOException {
        if (this.fileQueue == null) {
            this.fileQueue = File.createTempFile(DiskQueue.class.getSimpleName() + "-backingstore-", null, this.tempDir);
            this.fileQueue.deleteOnExit();
            LOG.log(Level.INFO, "created backing store {0}", this.fileQueue.getAbsolutePath());
            this.fileOut = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.fileQueue.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            this.fileOut.flush();
            this.fileIn = new BufferedReader(new InputStreamReader(Files.newInputStream(this.fileQueue.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.memoryQueue.size() + this.fileElementCount + (this.cachedElement != null ? 1 : 0);
    }

    @Override
    public boolean offer(String element) {
        if (element == null) {
            throw new NullPointerException("Element cannot be null for AbstractQueue");
        }
        boolean hasFileQueue = this.fileQueue != null;
        boolean offerRejected = false;
        if (!hasFileQueue) {
            boolean bl = offerRejected = !this.memoryQueue.offer(element);
            if (offerRejected) {
                this.memoryIterator = this.memoryQueue.iterator();
            }
        }
        if (hasFileQueue || offerRejected) {
            try {
                this.openFile();
                this.fileOut.write(element);
                this.fileOut.newLine();
                ++this.fileElementCount;
            }
            catch (IOException e) {
                LOG.severe(MessageFormat.format("Error writing to {0} backing store", DiskQueue.class.getSimpleName()));
                return false;
            }
        }
        return true;
    }

    @Override
    public String peek() {
        this.loadMemoryQueue();
        return this.memoryQueue.peek();
    }

    @Override
    public String remove() {
        this.loadMemoryQueue();
        return this.memoryQueue.remove();
    }

    @Override
    public String poll() {
        this.loadMemoryQueue();
        return this.memoryQueue.poll();
    }

    @Override
    public void clear() {
        this.memoryQueue.clear();
        this.cachedElement = null;
        this.closeFile();
    }

    void loadMemoryQueue() {
        if ((float)this.memoryQueue.size() / (float)this.memoryQueue.getCapacity() >= this.refillMemoryRatio) {
            return;
        }
        if (this.cachedElement != null && this.memoryQueue.offer(this.cachedElement)) {
            this.cachedElement = null;
        }
        if (this.fileQueue != null) {
            try {
                this.fileOut.flush();
                while (this.fileElementCount > 0) {
                    String nextFileElement = this.fileIn.readLine();
                    --this.fileElementCount;
                    if (DiskQueue.isEmpty(nextFileElement) || this.memoryQueue.offer(nextFileElement)) continue;
                    this.cachedElement = nextFileElement;
                    this.memoryIterator = this.memoryQueue.iterator();
                    return;
                }
                this.memoryIterator = this.memoryQueue.iterator();
                this.closeFile();
            }
            catch (IOException e) {
                LOG.severe(MessageFormat.format("Error reading from {0} backing store", DiskQueue.class.getSimpleName()));
            }
        }
    }

    private static class MemoryQueue<E>
    extends AbstractQueue<String> {
        private final Deque<String> queue;
        private final int capacity;

        public MemoryQueue(int capacity) {
            this.capacity = capacity;
            this.queue = new ArrayDeque<String>(capacity);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.queue.iterator();
        }

        public int getCapacity() {
            return this.capacity;
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean offer(String o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (this.queue.size() >= this.capacity) {
                return false;
            }
            this.queue.add(o);
            return true;
        }

        @Override
        public String peek() {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.peek();
        }

        @Override
        public String poll() {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.poll();
        }

        @Override
        public String remove() {
            return this.queue.remove();
        }
    }

    private class Itr
    implements Iterator<String> {
        public Itr() {
            DiskQueue.this.memoryIterator = DiskQueue.this.memoryQueue.iterator();
        }

        @Override
        public boolean hasNext() {
            return DiskQueue.this.memoryIterator.hasNext() || DiskQueue.this.fileElementCount > 0 || DiskQueue.this.cachedElement != null;
        }

        @Override
        public String next() {
            String next = DiskQueue.this.memoryIterator.next();
            if (!(DiskQueue.this.memoryIterator.hasNext() || DiskQueue.this.fileElementCount <= 0 && DiskQueue.this.cachedElement == null)) {
                DiskQueue.this.memoryQueue.clear();
                DiskQueue.this.loadMemoryQueue();
            }
            return next;
        }

        @Override
        public void remove() {
            DiskQueue.this.memoryIterator.remove();
        }
    }
}

