/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.hub.step.AbstractStepDefinition;
import com.marklogic.hub.step.impl.CustomStepDefinitionImpl;
import com.marklogic.hub.step.impl.IngestionStepDefinitionImpl;
import com.marklogic.hub.step.impl.MappingStepDefinitionImpl;
import com.marklogic.hub.step.impl.MasteringStepDefinitionImpl;
import com.marklogic.hub.step.impl.MatchingStepDefinitionImpl;
import com.marklogic.hub.step.impl.MergingStepDefinitionImpl;
import com.marklogic.hub.step.impl.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public interface StepDefinition {
    public static StepDefinition create(String name, StepDefinitionType type) {
        AbstractStepDefinition stepDefinition = null;
        switch (type) {
            case INGESTION: {
                stepDefinition = new IngestionStepDefinitionImpl(name);
                break;
            }
            case MAPPING: {
                stepDefinition = new MappingStepDefinitionImpl(name);
                break;
            }
            case MASTERING: {
                stepDefinition = new MasteringStepDefinitionImpl(name);
                break;
            }
            case MERGING: {
                stepDefinition = new MergingStepDefinitionImpl(name);
                break;
            }
            case MATCHING: {
                stepDefinition = new MatchingStepDefinitionImpl(name);
                break;
            }
            case CUSTOM: {
                stepDefinition = new CustomStepDefinitionImpl(name);
            }
        }
        return stepDefinition;
    }

    public String getName();

    public void setName(String var1);

    @Deprecated
    public String getLanguage();

    public String getLang();

    public Integer getVersion();

    public void setVersion(Integer var1);

    public Map<String, Object> getOptions();

    public void setOptions(Map<String, Object> var1);

    public String getModulePath();

    public void setModulePath(String var1);

    public JsonNode getCustomHook();

    public void setCustomHook(JsonNode var1);

    public String getSourceQuery();

    public void setSourceQuery(String var1);

    public int getRetryLimit();

    public void setRetryLimit(int var1);

    public StepDefinitionType getType();

    public void setType(StepDefinitionType var1);

    public String getDescription();

    public void setDescription(String var1);

    public Integer getBatchSize();

    public void setBatchSize(Integer var1);

    public Integer getThreadCount();

    public void setThreadCount(Integer var1);

    public void incrementVersion();

    public void deserialize(JsonNode var1);

    public Step transformToStep(String var1, StepDefinition var2, Step var3);

    public StepDefinition transformFromStep(StepDefinition var1, Step var2);

    public static enum StepDefinitionType {
        INGESTION("ingestion"),
        MAPPING("mapping"),
        MASTERING("mastering"),
        MATCHING("matching"),
        MERGING("merging"),
        CUSTOM("custom");

        private final String type;

        private StepDefinitionType(String type) {
            this.type = type;
        }

        public static StepDefinitionType getStepDefinitionType(String type) {
            for (StepDefinitionType stepDefinitionType : StepDefinitionType.values()) {
                if (!stepDefinitionType.toString().equalsIgnoreCase(type)) continue;
                return stepDefinitionType;
            }
            return null;
        }

        public static ArrayList<StepDefinitionType> getStepDefinitionTypes() {
            return new ArrayList<StepDefinitionType>(Arrays.asList(StepDefinitionType.values()));
        }

        public String toString() {
            return this.type;
        }
    }
}

