/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.hub.flow.FlowInputs;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.FileCopyUtils;

public class CommandLineFlowInputs {
    private String flowName;
    private Integer batchSize;
    private Integer threadCount;
    private String inputFilePath;
    private String inputFileType;
    private String outputURIReplacement;
    private String outputURIPrefix;
    private String separator;
    private Boolean failHard = false;
    private List<String> steps;
    private String jobId;
    private String optionsJSON;
    private String optionsFile;
    private Boolean showOptions = false;

    public Pair<FlowInputs, String> buildFlowInputs() {
        StringBuilder runFlowString = new StringBuilder("Running flow: [" + this.flowName + "]");
        if (this.steps != null) {
            runFlowString.append(", steps: ").append(this.steps);
        }
        FlowInputs flowInputs = new FlowInputs(this.flowName);
        flowInputs.setSteps(this.steps);
        flowInputs.setJobId(this.jobId);
        flowInputs.setStepConfig(this.buildStepConfig(runFlowString));
        Map<String, Object> flowOptions = this.buildFlowOptions();
        flowInputs.setOptions(flowOptions);
        if (this.showOptions.booleanValue() && flowOptions != null) {
            runFlowString.append("\n\tand options:");
            for (Map.Entry<String, Object> entry : flowOptions.entrySet()) {
                runFlowString.append("\n\t\t").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
        }
        return Pair.of((Object)flowInputs, (Object)runFlowString.toString());
    }

    protected Map<String, Object> buildStepConfig(StringBuilder runFlowString) {
        HashMap<String, Object> stepConfig = new HashMap<String, Object>();
        if (this.batchSize != null) {
            runFlowString.append("\n\twith batch size: ").append(this.batchSize);
            stepConfig.put("batchSize", this.batchSize);
        }
        if (this.threadCount != null) {
            runFlowString.append("\n\twith thread count: ").append(this.threadCount);
            stepConfig.put("threadCount", this.threadCount);
        }
        if (this.failHard.booleanValue()) {
            runFlowString.append("\n\t\twith fail hard: ").append(this.failHard);
            stepConfig.put("stopOnFailure", this.failHard);
        }
        if (this.inputFileType != null || this.inputFilePath != null || this.outputURIReplacement != null || this.separator != null || this.outputURIPrefix != null) {
            runFlowString.append("\n\tWith File Locations Settings:");
            HashMap<String, String> fileLocations = new HashMap<String, String>();
            if (this.inputFileType != null) {
                runFlowString.append("\n\t\tInput File Type: ").append(this.inputFileType);
                fileLocations.put("inputFileType", this.inputFileType);
            }
            if (this.inputFilePath != null) {
                runFlowString.append("\n\t\tInput File Path: ").append(this.inputFilePath);
                fileLocations.put("inputFilePath", this.inputFilePath);
            }
            if (this.outputURIPrefix != null) {
                runFlowString.append("\n\t\tOutput URI Prefix: ").append(this.outputURIPrefix);
                fileLocations.put("outputURIPrefix", this.outputURIPrefix);
            }
            if (this.outputURIReplacement != null) {
                runFlowString.append("\n\t\tOutput URI Replacement: ").append(this.outputURIReplacement);
                fileLocations.put("outputURIReplacement", this.outputURIReplacement);
            }
            if (this.separator != null) {
                if (this.inputFileType != null && !this.inputFileType.equalsIgnoreCase("csv")) {
                    throw new IllegalArgumentException("Invalid argument for file type " + this.inputFileType + ". When specifying a separator, the file type must be 'csv'");
                }
                runFlowString.append("\n\t\tSeparator: ").append(this.separator);
                fileLocations.put("separator", this.separator);
            }
            stepConfig.put("fileLocations", fileLocations);
        }
        return stepConfig;
    }

    protected Map<String, Object> buildFlowOptions() {
        String optionsString;
        if (StringUtils.isNotEmpty((CharSequence)this.optionsFile)) {
            try {
                optionsString = new String(FileCopyUtils.copyToByteArray((File)new File(this.optionsFile)), StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read options file at: " + this.optionsFile, ex);
            }
        } else {
            optionsString = this.optionsJSON;
        }
        Map<String, Boolean> optionsMap = null;
        if (StringUtils.isNotEmpty((CharSequence)optionsString)) {
            try {
                optionsMap = (Map)new ObjectMapper().readValue(optionsString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to parse JSON options string: " + optionsString, ex);
            }
        }
        if (this.failHard.booleanValue()) {
            if (optionsMap == null) {
                optionsMap = new HashMap<String, Boolean>();
            }
            optionsMap.put("stopOnError", true);
        }
        return optionsMap;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public String getInputFileType() {
        return this.inputFileType;
    }

    public void setInputFileType(String inputFileType) {
        this.inputFileType = inputFileType;
    }

    public String getOutputURIReplacement() {
        return this.outputURIReplacement;
    }

    public void setOutputURIReplacement(String outputURIReplacement) {
        this.outputURIReplacement = outputURIReplacement;
    }

    public String getOutputURIPrefix() {
        return this.outputURIPrefix;
    }

    public void setOutputURIPrefix(String outputURIPrefix) {
        this.outputURIPrefix = outputURIPrefix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public Boolean getShowOptions() {
        return this.showOptions;
    }

    public void setShowOptions(Boolean showOptions) {
        this.showOptions = showOptions;
    }

    public Boolean getFailHard() {
        return this.failHard;
    }

    public void setFailHard(Boolean failHard) {
        this.failHard = failHard;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public void setSteps(List<String> steps) {
        this.steps = steps;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getOptionsFile() {
        return this.optionsFile;
    }

    public void setOptionsFile(String optionsFile) {
        this.optionsFile = optionsFile;
    }

    public String getOptionsJSON() {
        return this.optionsJSON;
    }

    public void setOptionsJSON(String optionsJSON) {
        this.optionsJSON = optionsJSON;
    }
}

