/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.hubcentral.conversion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.hubcentral.conversion.FlowConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class HubCentralConverter
extends LoggingObject {
    private static final List<String> removableIndexArrays = Arrays.asList("elementRangeIndex", "rangeIndex", "pathRangeIndex");
    private final HubConfig hubConfig;
    private final FlowConverter flowConverter;
    private final ObjectMapper mapper = new ObjectMapper();

    public HubCentralConverter(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        this.flowConverter = new FlowConverter(this.hubConfig);
    }

    public void convertUserArtifacts() {
        this.flowConverter.convertFlows();
        this.convertEntityModels();
        this.logger.warn("\nRemember to update your custom modules that accept match rulesets or merge rules as input. These rulesets, rules, and their associated options are now in the Hub Central format and are passed to XQuery functions as object-node() objects and to JavaScript functions as JSON objects.");
    }

    protected void convertEntityModels() {
        HubProject hubProject = this.hubConfig.getHubProject();
        File entityModelsDir = hubProject.getHubEntitiesDir().toFile();
        if (!entityModelsDir.exists()) {
            this.logger.warn("No entities directory exists, so no entity models will be converted");
            return;
        }
        this.logger.warn("Beginning conversion of entity models in entities directory");
        Path convertedEntitiesPath = hubProject.getProjectDir().resolve("converted-entities");
        try {
            convertedEntitiesPath.toFile().mkdirs();
            FileUtils.copyDirectory((File)entityModelsDir, (File)convertedEntitiesPath.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't convert entity models as backing up models failed : " + e.getMessage(), e);
        }
        ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
        boolean atLeastOneEntityModelWasConverted = false;
        File[] entityModelDefs = entityModelsDir.listFiles((dir, name) -> name.endsWith(".entity.json"));
        if (entityModelDefs == null) {
            this.logger.warn("No entity definitions were converted.");
            return;
        }
        for (File entityModelDef : entityModelDefs) {
            JsonNode entityModelNode = null;
            String fileName = entityModelDef.getName();
            try {
                FileInputStream fileInputStream = new FileInputStream(entityModelDef);
                entityModelNode = this.mapper.readTree((InputStream)fileInputStream);
                fileInputStream.close();
            }
            catch (IOException e) {
                this.logger.warn(this.format("Ignoring %s entity model definition as malformed JSON content is found", new Object[]{fileName}));
                this.logger.error(e.getMessage());
            }
            if (entityModelNode == null || !this.entityModelRequiresConversion(fileName, entityModelNode)) continue;
            String title = entityModelNode.path("info").path("title").asText();
            ObjectNode entityTypeNode = (ObjectNode)entityModelNode.get("definitions").get(title);
            List elementRangeIndex = (List)this.mapper.convertValue((Object)entityTypeNode.get("elementRangeIndex"), ArrayList.class);
            elementRangeIndex = elementRangeIndex == null ? new ArrayList() : elementRangeIndex;
            List rangeIndex = (List)this.mapper.convertValue((Object)entityTypeNode.get("rangeIndex"), ArrayList.class);
            rangeIndex = rangeIndex == null ? new ArrayList() : rangeIndex;
            List pathRangeIndex = (List)this.mapper.convertValue((Object)entityTypeNode.get("pathRangeIndex"), ArrayList.class);
            pathRangeIndex = pathRangeIndex == null ? new ArrayList() : pathRangeIndex;
            HashSet mergedIndexArrays = new HashSet();
            Stream.of(elementRangeIndex, rangeIndex, pathRangeIndex).forEach(mergedIndexArrays::addAll);
            ObjectNode entityTypePropertiesNode = (ObjectNode)entityTypeNode.get("properties");
            if (entityTypePropertiesNode == null) {
                this.logger.warn("entityTypePropertiesNode is null");
                entityTypeNode.remove(removableIndexArrays);
                atLeastOneEntityModelWasConverted = true;
                continue;
            }
            entityTypePropertiesNode.fieldNames().forEachRemaining(propertyName -> {
                ObjectNode entityPropertyNode;
                if (mergedIndexArrays.contains(propertyName) && !HubCentralConverter.isStructuredTypeProperty(entityPropertyNode = (ObjectNode)entityTypePropertiesNode.get(propertyName))) {
                    entityPropertyNode.put("facetable", true);
                }
            });
            entityTypeNode.remove(removableIndexArrays);
            try {
                writer.writeValue(entityModelDef, (Object)entityModelNode);
                this.logger.warn(this.format("Entity Model '%s' was successfully converted", new Object[]{entityModelDef}));
                atLeastOneEntityModelWasConverted = true;
            }
            catch (IOException e) {
                this.logger.error(this.format("Entity Model '%s' conversion failed; cause: %s", new Object[]{entityModelDef, e.getMessage()}), (Throwable)e);
            }
        }
        if (atLeastOneEntityModelWasConverted) {
            this.logger.warn("Finished converting entity models.");
            this.logger.warn("Please examine your entity model files to verify that properties that were listed in the rangeIndex, pathRangeIndex, or elementRangeIndex arrays now have \"facetable\":true in their property definition.\n");
        } else {
            this.logger.warn("No entity models required conversion, so no project files were modified");
        }
    }

    protected boolean entityModelRequiresConversion(String fileName, JsonNode entityModelNode) {
        if (!this.entityModelValidForConversion(fileName, entityModelNode)) {
            return false;
        }
        String firstLevelEntityTypeName = entityModelNode.get("info").get("title").asText();
        return (entityModelNode = entityModelNode.get("definitions").get(firstLevelEntityTypeName)).get("rangeIndex") != null || entityModelNode.get("elementRangeIndex") != null || entityModelNode.get("pathRangeIndex") != null;
    }

    protected boolean entityModelValidForConversion(String fileName, JsonNode entityModelNode) {
        if (entityModelNode == null) {
            this.logger.warn(this.format("No content exist in the entity model definition %s and can not be converted", new Object[]{fileName}));
            return false;
        }
        if (!entityModelNode.has("info")) {
            this.logger.warn(this.format("Info doesn't exist in the entity model definition %s and can not be converted", new Object[]{fileName}));
            return false;
        }
        if (!entityModelNode.get("info").has("title")) {
            this.logger.warn(this.format("Title doesn't exist in the entity model definition %s in the info and can not be converted", new Object[]{fileName}));
            return false;
        }
        if (entityModelNode.get("info").get("title") == null || entityModelNode.get("info").get("title").asText().isEmpty()) {
            this.logger.warn(this.format("Title is empty in the entity model definition %s in the info and can not be converted", new Object[]{fileName}));
            return false;
        }
        String title = entityModelNode.get("info").get("title").asText();
        if (!entityModelNode.has("definitions")) {
            this.logger.warn(this.format("No definitions found in the entity model definition %s and can not be converted", new Object[]{fileName}));
            return false;
        }
        if (entityModelNode.get("definitions").get(title) == null) {
            this.logger.warn(this.format("entityType with title %s does not exist in the entity model definition %s", new Object[]{title, fileName}));
            return false;
        }
        return true;
    }

    private static boolean isStructuredTypeProperty(ObjectNode entityPropertyNode) {
        if (entityPropertyNode.get("datatype") == null && entityPropertyNode.get("$ref") != null) {
            return true;
        }
        return entityPropertyNode.get("datatype") != null && entityPropertyNode.get("datatype").asText().equals("array") && entityPropertyNode.get("items") != null && entityPropertyNode.get("items").get("$ref") != null;
    }
}

