/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.flow.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.util.json.JSONObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FlowImpl
implements Flow {
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_THREAD_COUNT = 4;
    public static final boolean DEFAULT_STOP_ONERROR = false;
    private String name;
    private String description;
    private int batchSize;
    private int threadCount;
    private boolean stopOnError;
    private JsonNode options;
    private int version;
    private Map<String, Step> steps = new LinkedHashMap<String, Step>();
    @JsonIgnore
    private Map<String, Object> runtimeOptions;
    @JsonIgnore
    private Map<String, Object> overrideStepConfig;

    @Override
    public Map<String, Object> getOverrideStepConfig() {
        return this.overrideStepConfig;
    }

    @Override
    public void setOverrideStepConfig(Map<String, Object> overrideStepConfig) {
        this.overrideStepConfig = overrideStepConfig;
    }

    @Override
    public void setRuntimeOptions(Map<String, Object> runtimeOptions) {
        this.runtimeOptions = runtimeOptions;
    }

    @Override
    public Map<String, Object> getRuntimeOptions() {
        return this.runtimeOptions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String flowName) {
        this.name = flowName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public JsonNode getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(JsonNode options) {
        this.options = options;
    }

    @Override
    public Map<String, Step> getSteps() {
        return this.steps;
    }

    @Override
    public void setSteps(Map<String, Step> steps) {
        this.steps = steps;
    }

    @Override
    public Step getStep(String stepKey) {
        return this.steps.get(stepKey);
    }

    @Override
    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    @Override
    public boolean isStopOnError() {
        return this.stopOnError;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public Flow deserialize(JsonNode json) {
        JSONObject jsonObject = new JSONObject(json);
        this.setName(jsonObject.getString("name"));
        this.setDescription(jsonObject.getString("description"));
        this.setBatchSize(jsonObject.getInt("batchSize", 100));
        this.setThreadCount(jsonObject.getInt("threadCount", 4));
        this.setOptions(jsonObject.getNode("options"));
        this.setStopOnError(jsonObject.getBoolean("stopOnError", false));
        JsonNode stepNode = jsonObject.getNode("steps");
        if (stepNode != null) {
            Iterator iterator = stepNode.fieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Step step = Step.deserialize(stepNode.get(key));
                this.steps.put(key, step);
            }
            this.setSteps(this.steps);
        }
        return this;
    }

    @Override
    @Deprecated
    public Step getStepById(String stepKey) {
        if (StringUtils.isEmpty((CharSequence)stepKey)) {
            return null;
        }
        return this.steps.get(stepKey);
    }
}

