/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.MappingService;
import com.marklogic.hub.deploy.commands.LoadUserModulesCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenerateFunctionMetadataCommand
extends AbstractCommand {
    @Autowired
    private HubConfig hubConfig;
    private static final String DH_FUNCTION_MODULE_PATH = "/data-hub/5/mapping-functions/";
    private static final String USER_FUNCTION_MODULE_PATH = "/custom-modules/mapping-functions/";
    private boolean catchExceptionsForUserModules = false;

    public GenerateFunctionMetadataCommand() {
        this.setExecuteSortOrder(new LoadUserModulesCommand().getExecuteSortOrder() + 1);
    }

    public GenerateFunctionMetadataCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public void execute(CommandContext context) {
        this.generateFunctionMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFunctionMetadata() {
        DatabaseClient stagingClient = this.hubConfig.newStagingClient(null);
        MappingService mappingService = MappingService.on(stagingClient);
        try {
            block5: {
                try {
                    mappingService.generateMappingFunctions();
                }
                catch (FailedRequestException ex) {
                    if (this.isCatchExceptionsForUserModules()) break block5;
                    throw ex;
                }
            }
            mappingService.generateMappingTransforms();
        }
        finally {
            stagingClient.release();
        }
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void setCatchExceptionsForUserModules(boolean catchExceptionsForUserModules) {
        this.catchExceptionsForUserModules = catchExceptionsForUserModules;
    }

    public boolean isCatchExceptionsForUserModules() {
        return this.catchExceptionsForUserModules;
    }
}

