/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.security.Privilege;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.api.security.RolePrivilege;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.groups.GroupManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import com.marklogic.mgmt.resource.security.RoleManager;
import com.marklogic.rest.util.ResourcesFragment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jdom2.Namespace;
import org.springframework.web.client.HttpServerErrorException;

public class CreateGranularPrivilegesCommand
extends LoggingObject
implements Command,
UndoableCommand {
    private final HubConfig hubConfig;
    private List<String> groupNames;
    public static final List<String> ROLES_THAT_CAN_BE_INHERITED = Collections.unmodifiableList(Arrays.asList("data-hub-admin", "data-hub-developer", "data-hub-monitor", "data-hub-operator", "hub-central-clear-user-data", "hub-central-custom-reader", "hub-central-custom-writer", "hub-central-developer", "hub-central-downloader", "hub-central-entity-exporter", "hub-central-entity-model-reader", "hub-central-entity-model-writer", "hub-central-flow-writer", "hub-central-load-reader", "hub-central-load-writer", "hub-central-mapping-reader", "hub-central-mapping-writer", "hub-central-operator", "hub-central-saved-query-user", "hub-central-step-runner", "hub-central-user", "data-hub-common", "data-hub-common-writer", "data-hub-custom-reader", "data-hub-custom-writer", "data-hub-entity-model-reader", "data-hub-entity-model-writer", "data-hub-flow-reader", "data-hub-flow-writer", "data-hub-ingestion-reader", "data-hub-ingestion-writer", "data-hub-job-reader", "data-hub-mapping-reader", "data-hub-mapping-writer", "data-hub-match-merge-reader", "data-hub-match-merge-writer", "data-hub-module-reader", "data-hub-module-writer", "data-hub-odbc-user", "data-hub-saved-query-user", "data-hub-spawn-user", "data-hub-step-definition-reader", "data-hub-step-definition-writer", "data-hub-temporal-user", "data-hub-user-reader", "pii-reader", "redaction-user", "data-hub-http-user", "rest-reader", "rest-writer", "dls-user", "dls-admin"));

    public CreateGranularPrivilegesCommand(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public CreateGranularPrivilegesCommand(HubConfig hubConfig, List<String> groupNames) {
        this.hubConfig = hubConfig;
        this.groupNames = groupNames;
    }

    public Integer getExecuteSortOrder() {
        return Integer.MAX_VALUE;
    }

    public Integer getUndoSortOrder() {
        return SortOrderConstants.DELETE_OTHER_DATABASES - 1;
    }

    public void execute(CommandContext context) {
        String xquery;
        DatabaseClient client;
        try {
            client = this.hubConfig.newFinalClient();
            xquery = "xquery version \"1.0-ml\";\nimport module namespace sec=\"http://marklogic.com/xdmp/security\" at \n    \"/MarkLogic/security.xqy\";\n\nxdmp:invoke-function(function() {\n  for $privilege in (\n      \"admin-database-clear-data-hub-STAGING\",\n      \"admin-database-clear-data-hub-FINAL\",\n      \"admin-database-clear-data-hub-JOBS\",\n      \"admin-database-index-data-hub-STAGING\",\n      \"admin-database-index-data-hub-FINAL\",\n      \"admin-database-index-data-hub-JOBS\",\n      \"admin-database-triggers-data-hub-staging-TRIGGERS\",\n      \"admin-database-triggers-data-hub-final-TRIGGERS\",\n      \"admin-database-temporal-data-hub-STAGING\",\n      \"admin-database-temporal-data-hub-FINAL\",\n      \"admin-database-alerts-data-hub-STAGING\",\n      \"admin-database-alerts-data-hub-FINAL\",\n      \"admin-database-amp-data-hub-MODULES\"\n  )\n  for $privilege-xml in /sec:privilege[sec:privilege-name eq $privilege][sec:kind eq \"execute\"]\n  let $action := $privilege-xml/sec:action ! fn:string(.)\n  let $db-id := fn:substring($action, fn:index-of(fn:string-to-codepoints($action), fn:string-to-codepoints(\"/\"))[fn:last()] + 1)\n  let $db-exists := try { let $_name := xdmp:database-name(xs:unsignedLong($db-id)) return fn:true() } catch * {fn:false()}\n  where fn:not($db-exists)\n  return sec:remove-privilege($action, \"execute\")\n}, map:entry(\"database\", xdmp:security-database()))\n";
            client.newServerEval().xquery(xquery).eval().close();
        }
        catch (FailedRequestException e) {
            throw new RuntimeException("Unable to fix broken granular privileges", e);
        }
        try {
            client = this.hubConfig.newFinalClient();
            xquery = "xquery version \"1.0-ml\";\nimport module namespace sec=\"http://marklogic.com/xdmp/security\" at \n    \"/MarkLogic/security.xqy\";\n\nxdmp:invoke-function(function() {\n  for $groupId in (\n      xdmp:groups()\n  )\n  let $privilageName := 'admin-group-scheduled-task-' || xdmp:group-name($groupId)\n  for $privilege-xml in /sec:privilege[sec:privilege-name eq $privilageName ][sec:kind eq \"execute\"]\n  let $action := $privilege-xml/sec:action ! fn:string(.)\n  let $group-name := fn:substring($action, fn:index-of(fn:string-to-codepoints($action), fn:string-to-codepoints(\"/\"))[fn:last()] + 1)\n  let $group-exists := try { let $_name := xdmp:group-name(xs:unsignedLong($group-name)) return fn:true() } catch * {fn:false()}\n  where fn:not($group-exists)\n  return sec:remove-privilege($action, \"execute\")\n}, map:entry(\"database\", xdmp:security-database()))\n";
            client.newServerEval().xquery(xquery).eval().close();
        }
        catch (FailedRequestException e) {
            throw new RuntimeException("Unable to fix broken granular privileges", e);
        }
        Map<String, Privilege> granularPrivileges = this.buildGranularPrivileges(context.getManageClient());
        this.saveGranularPrivileges(context.getManageClient(), granularPrivileges);
    }

    public void undo(CommandContext context) {
        Map<String, Privilege> granularPrivileges = this.buildGranularPrivileges(context.getManageClient());
        PrivilegeManager mgr = new PrivilegeManager(context.getManageClient());
        granularPrivileges.values().forEach(privilege -> mgr.deleteAtPath("/manage/v2/privileges/" + privilege.getPrivilegeName() + "?kind=execute"));
    }

    protected Map<String, Privilege> buildGranularPrivileges(ManageClient manageClient) {
        String finalDbName = this.hubConfig.getDbName(DatabaseKind.FINAL);
        String stagingDbName = this.hubConfig.getDbName(DatabaseKind.STAGING);
        String jobsDbName = this.hubConfig.getDbName(DatabaseKind.JOB);
        String finalTriggersDbName = this.hubConfig.getDbName(DatabaseKind.FINAL_TRIGGERS);
        String stagingTriggersDbName = this.hubConfig.getDbName(DatabaseKind.STAGING_TRIGGERS);
        String modulesDbName = this.hubConfig.getDbName(DatabaseKind.MODULES);
        DatabaseManager dbMgr = new DatabaseManager(manageClient);
        ResourcesFragment databases = dbMgr.getAsXml();
        String finalDbId = databases.getIdForNameOrId(finalDbName);
        String stagingDbId = databases.getIdForNameOrId(stagingDbName);
        String jobsDbId = databases.getIdForNameOrId(jobsDbName);
        String finalTriggersDbId = databases.getIdForNameOrId(finalTriggersDbName);
        String stagingTriggersDbId = databases.getIdForNameOrId(stagingTriggersDbName);
        String modulesDbId = databases.getIdForNameOrId(modulesDbName);
        String adminRole = "data-hub-admin";
        String clearUserDataRole = "hub-central-clear-user-data";
        String developerRole = "data-hub-developer";
        String hubCentralEntityModelWriterRole = "hub-central-entity-model-writer";
        LinkedHashMap<String, Privilege> granularPrivilegeMap = new LinkedHashMap<String, Privilege>();
        Privilege p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-clear-" + stagingDbName, "data-hub-admin", "hub-central-clear-user-data");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/clear/$$database-id(" + stagingDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/clear/" + stagingDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-clear-" + finalDbName, "data-hub-admin", "hub-central-clear-user-data");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/clear/$$database-id(" + finalDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/clear/" + finalDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-clear-" + jobsDbName, "data-hub-admin", "hub-central-clear-user-data");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/clear/$$database-id(" + jobsDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/clear/" + jobsDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-index-" + stagingDbName, "data-hub-developer", "hub-central-entity-model-writer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/index/$$database-id(" + stagingDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/index/" + stagingDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-index-" + finalDbName, "data-hub-developer", "hub-central-entity-model-writer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/index/$$database-id(" + finalDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/index/" + finalDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-index-" + jobsDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/index/$$database-id(" + jobsDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/index/" + jobsDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-triggers-" + stagingTriggersDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/triggers/$$database-id(" + stagingTriggersDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/triggers/" + stagingTriggersDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-triggers-" + finalTriggersDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/triggers/$$database-id(" + finalTriggersDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/triggers/" + finalTriggersDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-temporal-" + stagingDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/temporal/$$database-id(" + stagingDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/temporal/" + stagingDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-temporal-" + finalDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/temporal/$$database-id(" + finalDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/temporal/" + finalDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-alerts-" + stagingDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/alerts/$$database-id(" + stagingDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/alerts/" + stagingDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-alerts-" + finalDbName, "data-hub-developer");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/alerts/$$database-id(" + finalDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/alerts/" + finalDbId, p);
        p = CreateGranularPrivilegesCommand.newPrivilege("admin-database-amp-" + modulesDbName, "data-hub-security-admin");
        p.setAction("http://marklogic.com/xdmp/privileges/admin/database/amp/$$database-id(" + modulesDbName + ")");
        granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/database/amp/" + modulesDbId, p);
        ResourcesFragment existingGroups = new GroupManager(manageClient).getAsXml();
        this.getGroupNamesForScheduledTaskPrivileges().forEach(groupName -> {
            String groupId = existingGroups.getIdForNameOrId(groupName);
            if (groupId == null) {
                this.logger.warn(this.format("Unable to find group ID for group name '%s'; will not create scheduled tasks privilege for the group", new Object[]{groupName}));
            } else {
                Privilege priv = CreateGranularPrivilegesCommand.newPrivilege("admin-group-scheduled-task-" + groupName, "data-hub-developer");
                priv.setAction("http://marklogic.com/xdmp/privileges/admin/group/scheduled-task/$$group-id(" + groupName + ")");
                granularPrivilegeMap.put("http://marklogic.com/xdmp/privileges/admin/group/scheduled-task/" + groupId, priv);
            }
        });
        ResourcesFragment existingRoles = new RoleManager(manageClient).getAsXml();
        ROLES_THAT_CAN_BE_INHERITED.forEach(roleName -> {
            String roleId = existingRoles.getIdForNameOrId(roleName);
            Privilege priv = CreateGranularPrivilegesCommand.newPrivilege("data-role-inherit-" + roleId, "data-hub-security-admin");
            priv.setAction("http://marklogic.com/xdmp/privileges/role/inherit/" + roleId);
            granularPrivilegeMap.put(priv.getAction(), priv);
        });
        return granularPrivilegeMap;
    }

    protected void saveGranularPrivileges(ManageClient manageClient, Map<String, Privilege> granularPrivileges) {
        try {
            DefaultResourceMapper resourceMapper = new DefaultResourceMapper(new API(manageClient));
            RoleManager roleManager = new RoleManager(manageClient);
            Map<String, String> actionToNameMap = CreateGranularPrivilegesCommand.buildExistingPrivilegeActionToNameMap(manageClient);
            Configuration privilegeConfig = new Configuration();
            HashMap roleMap = new HashMap();
            granularPrivileges.forEach((arg_0, arg_1) -> CreateGranularPrivilegesCommand.lambda$saveGranularPrivileges$4(actionToNameMap, privilegeConfig, roleMap, (ResourceMapper)resourceMapper, roleManager, arg_0, arg_1));
            Configurations configs = new Configurations();
            if (privilegeConfig.getPrivileges() != null && !privilegeConfig.getPrivileges().isEmpty()) {
                configs.addConfig(privilegeConfig);
            }
            Configuration roleConfig = new Configuration();
            for (Map.Entry roleEntry : roleMap.entrySet()) {
                roleConfig.addRole(((Role)roleEntry.getValue()).toObjectNode());
            }
            configs.addConfig(roleConfig);
            this.logger.info("Submitting CMA config containing privileges and roles");
            configs.submit(manageClient);
            this.logger.info("Finished submitting CMA config containing privileges and roles");
        }
        catch (Exception e) {
            if (e instanceof HttpServerErrorException.BadGateway) {
                boolean missedPrivileges = false;
                List privilegeNames = granularPrivileges.values().stream().map(privilege -> privilege.getPrivilegeName()).collect(Collectors.toList());
                PrivilegeManager privilegeManager = new PrivilegeManager(this.hubConfig.getManageClient());
                for (String privilegeName : privilegeNames) {
                    if (privilegeManager.exists(privilegeName, new String[0])) continue;
                    missedPrivileges = true;
                    this.logger.info(String.format("Privilege %s does not exist", privilegeName));
                }
                if (missedPrivileges) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> buildExistingPrivilegeActionToNameMap(ManageClient manageClient) {
        ResourcesFragment allPrivileges = new PrivilegeManager(manageClient).getAsXml();
        HashMap<String, String> actionToNameMap = new HashMap<String, String>();
        Namespace securityNamespace = Namespace.getNamespace((String)"http://marklogic.com/manage/security");
        allPrivileges.getListItems().forEach(privilege -> {
            String action = privilege.getChildText("action", securityNamespace);
            String name = privilege.getChildText("nameref", securityNamespace);
            actionToNameMap.put(action, name);
        });
        return actionToNameMap;
    }

    protected List<String> getGroupNamesForScheduledTaskPrivileges() {
        return this.groupNames != null && !this.groupNames.isEmpty() ? this.groupNames : Collections.singletonList(this.hubConfig.getAppConfig().getGroupName());
    }

    private static Privilege newPrivilege(String name, String ... roles) {
        Privilege p = new Privilege(null, name);
        p.setKind("execute");
        for (String role : roles) {
            p.addRole(role);
        }
        return p;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    private static /* synthetic */ void lambda$saveGranularPrivileges$4(Map actionToNameMap, Configuration privilegeConfig, Map roleMap, ResourceMapper resourceMapper, RoleManager roleManager, String actionWithId, Privilege privilege) {
        if (!actionToNameMap.containsKey(actionWithId)) {
            ObjectNode node = privilege.toObjectNode();
            node.remove("role");
            privilegeConfig.addPrivilege(node);
        }
        privilege.getRole().forEach(roleName -> {
            Role role;
            if (roleMap.containsKey(roleName)) {
                role = (Role)roleMap.get(roleName);
            } else {
                role = (Role)resourceMapper.readResource(roleManager.getPropertiesAsJson(roleName, new String[0]), Role.class);
                if (role.getPrivilege() == null) {
                    role.setPrivilege(new ArrayList());
                }
                roleMap.put(roleName, role);
            }
            role.getPrivilege().add(new RolePrivilege(privilege.getPrivilegeName(), privilege.getAction(), privilege.getKind()));
        });
    }
}

