/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface SystemService {
    public static SystemService on(DatabaseClient db) {
        return SystemService.on(db, null);
    }

    public static SystemService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class SystemServiceImpl
        implements SystemService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_getVersions;
            private BaseProxy.DBFunctionRequest req_finishHubDeployment;
            private BaseProxy.DBFunctionRequest req_hubDebug;
            private BaseProxy.DBFunctionRequest req_getDataHubConfig;

            SystemServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/system/", servDecl);
                this.req_getVersions = this.baseProxy.request("getVersions.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_finishHubDeployment = this.baseProxy.request("finishHubDeployment.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_hubDebug = this.baseProxy.request("hubDebug.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getDataHubConfig = this.baseProxy.request("getDataHubConfig.mjs", BaseProxy.ParameterValuesKind.NONE);
            }

            @Override
            public JsonNode getVersions() {
                return this.getVersions(this.req_getVersions.on(this.dbClient));
            }

            private JsonNode getVersions(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public void finishHubDeployment() {
                this.finishHubDeployment(this.req_finishHubDeployment.on(this.dbClient));
            }

            private void finishHubDeployment(BaseProxy.DBFunctionRequest request) {
                request.responseNone();
            }

            @Override
            public JsonNode hubDebug() {
                return this.hubDebug(this.req_hubDebug.on(this.dbClient));
            }

            private JsonNode hubDebug(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getDataHubConfig() {
                return this.getDataHubConfig(this.req_getDataHubConfig.on(this.dbClient));
            }

            private JsonNode getDataHubConfig(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }
        }
        return new SystemServiceImpl(db, serviceDeclaration);
    }

    public JsonNode getVersions();

    public void finishHubDeployment();

    public JsonNode hubDebug();

    public JsonNode getDataHubConfig();
}

