/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface ModelsService {
    public static ModelsService on(DatabaseClient db) {
        return ModelsService.on(db, null);
    }

    public static ModelsService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class ModelsServiceImpl
        implements ModelsService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_generateDatabaseProperties;
            private BaseProxy.DBFunctionRequest req_saveDraftModel;
            private BaseProxy.DBFunctionRequest req_deleteDraftModel;
            private BaseProxy.DBFunctionRequest req_createDraftModel;
            private BaseProxy.DBFunctionRequest req_generateProtectedPathConfig;
            private BaseProxy.DBFunctionRequest req_updateDraftModelInfo;
            private BaseProxy.DBFunctionRequest req_generateModelConfig;
            private BaseProxy.DBFunctionRequest req_getPrimaryEntityTypes;
            private BaseProxy.DBFunctionRequest req_saveModels;
            private BaseProxy.DBFunctionRequest req_getModelReferences;
            private BaseProxy.DBFunctionRequest req_publishDraftModels;
            private BaseProxy.DBFunctionRequest req_getLatestJobData;
            private BaseProxy.DBFunctionRequest req_updateDraftModelEntityTypes;

            ModelsServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/models/", servDecl);
                this.req_generateDatabaseProperties = this.baseProxy.request("generateDatabaseProperties.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_saveDraftModel = this.baseProxy.request("saveDraftModel.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_deleteDraftModel = this.baseProxy.request("deleteDraftModel.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_createDraftModel = this.baseProxy.request("createDraftModel.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_generateProtectedPathConfig = this.baseProxy.request("generateProtectedPathConfig.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_updateDraftModelInfo = this.baseProxy.request("updateDraftModelInfo.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_generateModelConfig = this.baseProxy.request("generateModelConfig.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getPrimaryEntityTypes = this.baseProxy.request("getPrimaryEntityTypes.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_saveModels = this.baseProxy.request("saveModels.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_getModelReferences = this.baseProxy.request("getModelReferences.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_publishDraftModels = this.baseProxy.request("publishDraftModels.mjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getLatestJobData = this.baseProxy.request("getLatestJobData.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_updateDraftModelEntityTypes = this.baseProxy.request("updateDraftModelEntityTypes.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
            }

            @Override
            public JsonNode generateDatabaseProperties(JsonNode models) {
                return this.generateDatabaseProperties(this.req_generateDatabaseProperties.on(this.dbClient), models);
            }

            private JsonNode generateDatabaseProperties(BaseProxy.DBFunctionRequest request, JsonNode models) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"models", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)models))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void saveDraftModel(JsonNode model) {
                this.saveDraftModel(this.req_saveDraftModel.on(this.dbClient), model);
            }

            private void saveDraftModel(BaseProxy.DBFunctionRequest request, JsonNode model) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"model", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)model))}).responseNone();
            }

            @Override
            public void deleteDraftModel(String entityName) {
                this.deleteDraftModel(this.req_deleteDraftModel.on(this.dbClient), entityName);
            }

            private void deleteDraftModel(BaseProxy.DBFunctionRequest request, String entityName) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"entityName", (boolean)false, (String)BaseProxy.StringType.fromString((String)entityName))}).responseNone();
            }

            @Override
            public JsonNode createDraftModel(JsonNode input) {
                return this.createDraftModel(this.req_createDraftModel.on(this.dbClient), input);
            }

            private JsonNode createDraftModel(BaseProxy.DBFunctionRequest request, JsonNode input) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"input", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)input))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode generateProtectedPathConfig(JsonNode models) {
                return this.generateProtectedPathConfig(this.req_generateProtectedPathConfig.on(this.dbClient), models);
            }

            private JsonNode generateProtectedPathConfig(BaseProxy.DBFunctionRequest request, JsonNode models) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"models", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)models))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode updateDraftModelInfo(String name, JsonNode input) {
                return this.updateDraftModelInfo(this.req_updateDraftModelInfo.on(this.dbClient), name, input);
            }

            private JsonNode updateDraftModelInfo(BaseProxy.DBFunctionRequest request, String name, JsonNode input) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name)), BaseProxy.documentParam((String)"input", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)input))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode generateModelConfig() {
                return this.generateModelConfig(this.req_generateModelConfig.on(this.dbClient));
            }

            private JsonNode generateModelConfig(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getPrimaryEntityTypes(Boolean includeDrafts) {
                return this.getPrimaryEntityTypes(this.req_getPrimaryEntityTypes.on(this.dbClient), includeDrafts);
            }

            private JsonNode getPrimaryEntityTypes(BaseProxy.DBFunctionRequest request, Boolean includeDrafts) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"includeDrafts", (boolean)false, (String)BaseProxy.BooleanType.fromBoolean((Boolean)includeDrafts))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void saveModels(JsonNode models) {
                this.saveModels(this.req_saveModels.on(this.dbClient), models);
            }

            private void saveModels(BaseProxy.DBFunctionRequest request, JsonNode models) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"models", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)models))}).responseNone();
            }

            @Override
            public JsonNode getModelReferences(String entityName, String propertyName) {
                return this.getModelReferences(this.req_getModelReferences.on(this.dbClient), entityName, propertyName);
            }

            private JsonNode getModelReferences(BaseProxy.DBFunctionRequest request, String entityName, String propertyName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"entityName", (boolean)false, (String)BaseProxy.StringType.fromString((String)entityName)), BaseProxy.atomicParam((String)"propertyName", (boolean)true, (String)BaseProxy.StringType.fromString((String)propertyName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void publishDraftModels() {
                this.publishDraftModels(this.req_publishDraftModels.on(this.dbClient));
            }

            private void publishDraftModels(BaseProxy.DBFunctionRequest request) {
                request.responseNone();
            }

            @Override
            public JsonNode getLatestJobData(String entityCollection) {
                return this.getLatestJobData(this.req_getLatestJobData.on(this.dbClient), entityCollection);
            }

            private JsonNode getLatestJobData(BaseProxy.DBFunctionRequest request, String entityCollection) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"entityCollection", (boolean)false, (String)BaseProxy.StringType.fromString((String)entityCollection))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void updateDraftModelEntityTypes(JsonNode input) {
                this.updateDraftModelEntityTypes(this.req_updateDraftModelEntityTypes.on(this.dbClient), input);
            }

            private void updateDraftModelEntityTypes(BaseProxy.DBFunctionRequest request, JsonNode input) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"input", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)input))}).responseNone();
            }
        }
        return new ModelsServiceImpl(db, serviceDeclaration);
    }

    public JsonNode generateDatabaseProperties(JsonNode var1);

    public void saveDraftModel(JsonNode var1);

    public void deleteDraftModel(String var1);

    public JsonNode createDraftModel(JsonNode var1);

    public JsonNode generateProtectedPathConfig(JsonNode var1);

    public JsonNode updateDraftModelInfo(String var1, JsonNode var2);

    public JsonNode generateModelConfig();

    public JsonNode getPrimaryEntityTypes(Boolean var1);

    public void saveModels(JsonNode var1);

    public JsonNode getModelReferences(String var1, String var2);

    public void publishDraftModels();

    public JsonNode getLatestJobData(String var1);

    public void updateDraftModelEntityTypes(JsonNode var1);
}

