/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io.marker;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.lang.reflect.Array;

public interface ContentHandle<C>
extends AbstractReadHandle,
AbstractWriteHandle {
    public C get();

    public void set(C var1);

    default public Class<C> getContentClass() {
        C value = this.get();
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    default public ContentHandle<C> newHandle() {
        ContentHandle<C> newHandle = null;
        try {
            Class<C> contentClass = this.getContentClass();
            if (contentClass != null && DatabaseClientFactory.getHandleRegistry().isRegistered(contentClass)) {
                newHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(contentClass);
            }
            if (newHandle == null) {
                newHandle = (ContentHandle<C>)this.getClass().newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error constructing ContentHandle with DatabaseClientFactory.HandleFactoryRegistry or zero-argument constructor", e);
        }
        if (newHandle == null) {
            throw new RuntimeException("Could not construct ContentHandle with DatabaseClientFactory.HandleFactoryRegistry or zero-argument constructor");
        }
        if (!(this instanceof BaseHandle)) {
            throw new IllegalArgumentException("ContentHandle must also be BaseHandle");
        }
        BaseHandle thisBaseHandle = (BaseHandle)((Object)this);
        BaseHandle newBaseHandle = (BaseHandle)((Object)newHandle);
        newBaseHandle.setFormat(thisBaseHandle.getFormat());
        newBaseHandle.setMimetype(thisBaseHandle.getMimetype());
        return newHandle;
    }

    default public ContentHandle<C> newHandle(C content) {
        ContentHandle<C> handle = this.newHandle();
        handle.set(content);
        return handle;
    }

    default public C[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return (Object[])Array.newInstance(this.getContentClass(), length);
    }
}

