/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io.marker;

import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import java.lang.reflect.Array;

public interface BufferableContentHandle<C, R>
extends BufferableHandle,
ContentHandle<C> {
    public C toContent(R var1);

    public C bytesToContent(byte[] var1);

    public byte[] contentToBytes(C var1);

    public BufferableContentHandle<C, R> newHandle();

    default public BufferableContentHandle<C, R> newHandle(C content) {
        ContentHandle handle = this.newHandle();
        handle.set(content);
        return handle;
    }

    default public BufferableContentHandle<C, R>[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("handle array length less than zero: " + length);
        }
        return (BufferableContentHandle[])Array.newInstance(this.getClass(), length);
    }

    public BufferableContentHandle<?, ?> resendableHandleFor(C var1);

    default public BufferableContentHandle<?, ?>[] resendableHandleFor(C[] content) {
        if (content == null) {
            return null;
        }
        BufferableContentHandle[] result = new BufferableContentHandle[content.length];
        for (int i = 0; i < content.length; ++i) {
            result[i] = this.resendableHandleFor(content[i]);
        }
        return result;
    }
}

