/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.TuplesBuilder;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.TuplesReadHandle;
import com.marklogic.client.query.AggregateResult;
import com.marklogic.client.query.Tuple;
import com.marklogic.client.query.TuplesResults;
import com.marklogic.client.query.ValuesDefinition;
import com.marklogic.client.query.ValuesMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuplesHandle
extends BaseHandle<InputStream, OperationNotSupported>
implements TuplesReadHandle,
TuplesResults {
    private static final Logger logger = LoggerFactory.getLogger(DOMHandle.class);
    private TuplesBuilder.Tuples tuplesHolder;
    private Unmarshaller unmarshaller;
    private ValuesDefinition valdef = null;
    private Map<String, AggregateResult> hashedAggregates = null;

    public TuplesHandle() {
        super.setFormat(Format.XML);
        try {
            JAXBContext jc = JaxbContextLoader.CACHED_CONTEXT;
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new MarkLogicBindingException((Exception)((Object)new JAXBException("JAXB context initialization failed")));
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("ValuesHandle supports the XML format only");
        }
    }

    public TuplesHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            this.tuplesHolder = (TuplesBuilder.Tuples)this.unmarshaller.unmarshal((Reader)new InputStreamReader(content, StandardCharsets.UTF_8));
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall tuples", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ValuesDefinition getQueryCriteria() {
        return this.valdef;
    }

    public void setQueryCriteria(ValuesDefinition vdef) {
        this.valdef = vdef;
    }

    @Override
    public String getName() {
        return this.tuplesHolder.getName();
    }

    @Override
    public Tuple[] getTuples() {
        return this.tuplesHolder.getTuples();
    }

    @Override
    public AggregateResult[] getAggregates() {
        return this.tuplesHolder.getAggregates();
    }

    @Override
    public AggregateResult getAggregate(String name) {
        if (this.hashedAggregates == null) {
            this.hashedAggregates = new HashMap<String, AggregateResult>();
            for (AggregateResult aggregate : this.tuplesHolder.getAggregates()) {
                this.hashedAggregates.put(aggregate.getName(), aggregate);
            }
        }
        if (this.hashedAggregates.containsKey(name)) {
            return this.hashedAggregates.get(name);
        }
        return null;
    }

    @Override
    public ValuesMetrics getMetrics() {
        return this.tuplesHolder.getMetrics();
    }

    private static class JaxbContextLoader {
        private static final JAXBContext CACHED_CONTEXT;

        private JaxbContextLoader() {
        }

        static {
            try {
                CACHED_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{TuplesBuilder.Tuples.class});
            }
            catch (JAXBException e) {
                throw new MarkLogicBindingException((Exception)((Object)e));
            }
        }
    }
}

