/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import okhttp3.OkHttpClient;
import okhttp3.Request;

class OAuthAuthenticationConfigurer
implements AuthenticationConfigurer<DatabaseClientFactory.OAuthContext> {
    OAuthAuthenticationConfigurer() {
    }

    @Override
    public void configureAuthentication(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.OAuthContext authContext) {
        clientBuilder.addInterceptor(chain -> {
            Request authenticatedRequest = this.makeAuthenticatedRequest(chain.request(), authContext);
            return chain.proceed(authenticatedRequest);
        });
    }

    Request makeAuthenticatedRequest(Request request, DatabaseClientFactory.OAuthContext authContext) {
        String authValue = String.format("Bearer %s", authContext.getToken());
        return request.newBuilder().header("Authorization", authValue).build();
    }
}

