/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.row.RowManager;
import com.marklogic.client.util.RequestParameters;
import java.util.Map;

class RowsParamsBuilder {
    private RequestParameters params = new RequestParameters();

    public RowsParamsBuilder(PlanBuilderBaseImpl.RequestPlan requestPlan) {
        Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> planParams = requestPlan.getParams();
        if (planParams != null) {
            for (Map.Entry<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> entry : planParams.entrySet()) {
                BaseTypeImpl.ParamBinder binder = entry.getValue();
                StringBuilder nameBuf = new StringBuilder("bind:");
                nameBuf.append(entry.getKey().getName());
                String paramQual = binder.getParamQualifier();
                if (paramQual != null) {
                    nameBuf.append(paramQual);
                }
                this.params.add(nameBuf.toString(), binder.getParamValue());
            }
        }
    }

    public RowsParamsBuilder withOutput(String output) {
        if (output != null) {
            this.params.add("output", output);
        }
        return this;
    }

    public RowsParamsBuilder withOutput(RowManager.RowStructure rowStructure) {
        if (rowStructure != null) {
            switch (rowStructure) {
                case ARRAY: {
                    return this.withOutput("array");
                }
                case OBJECT: {
                    return this.withOutput("object");
                }
            }
        }
        return this;
    }

    public RowsParamsBuilder withColumnTypes(RowManager.RowSetPart columnTypes) {
        if (columnTypes != null) {
            switch (columnTypes) {
                case HEADER: {
                    this.params.add("column-types", "header");
                    break;
                }
                case ROWS: {
                    this.params.add("column-types", "rows");
                }
            }
        }
        return this;
    }

    public RowsParamsBuilder withRowFormat(String rowFormat) {
        if (rowFormat != null) {
            this.params.add("row-format", rowFormat);
        }
        return this;
    }

    public RowsParamsBuilder withNodeColumns(String nodeColumns) {
        if (nodeColumns != null) {
            this.params.add("node-columns", nodeColumns);
        }
        return this;
    }

    public RowsParamsBuilder withOptimize(Integer optimize) {
        if (optimize != null) {
            this.params.add("optimize", optimize.toString());
        }
        return this;
    }

    public RowsParamsBuilder withTraceLabel(String label) {
        if (label != null) {
            this.params.add("tracelabel", label);
        }
        return this;
    }

    public RowsParamsBuilder withTimestamp(long serverTimestamp) {
        if (serverTimestamp > 0L) {
            this.params.add("timestamp", serverTimestamp + "");
        }
        return this;
    }

    public RequestParameters getRequestParameters() {
        return this.params;
    }
}

