/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.Transaction;
import com.marklogic.client.expression.CtsQueryBuilder;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.CtsQueryBuilderImpl;
import com.marklogic.client.impl.DeleteQueryDefinitionImpl;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.RawQueryDefinitionImpl;
import com.marklogic.client.impl.StringQueryDefinitionImpl;
import com.marklogic.client.impl.SuggestDefinitionImpl;
import com.marklogic.client.impl.UrisReadHandle;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.impl.ValuesDefinitionImpl;
import com.marklogic.client.impl.ValuesListDefinitionImpl;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.SearchHandle;
import com.marklogic.client.io.TuplesHandle;
import com.marklogic.client.io.ValuesHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.QueryOptionsListReadHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TuplesReadHandle;
import com.marklogic.client.io.marker.ValuesListReadHandle;
import com.marklogic.client.io.marker.ValuesReadHandle;
import com.marklogic.client.query.DeleteQueryDefinition;
import com.marklogic.client.query.MatchDocumentSummary;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawCtsQueryDefinition;
import com.marklogic.client.query.RawQueryByExampleDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.SearchQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.SuggestDefinition;
import com.marklogic.client.query.ValuesDefinition;
import com.marklogic.client.query.ValuesListDefinition;
import com.marklogic.client.util.RequestParameters;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class QueryManagerImpl
extends AbstractLoggingManager
implements QueryManager {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private long pageLen = -1L;
    private QueryManager.QueryView view = QueryManager.QueryView.DEFAULT;

    public QueryManagerImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public long getPageLength() {
        return this.pageLen;
    }

    @Override
    public void setPageLength(long length) {
        this.pageLen = length;
    }

    @Override
    public QueryManager.QueryView getView() {
        return this.view;
    }

    @Override
    public void setView(QueryManager.QueryView view) {
        this.view = view == null ? QueryManager.QueryView.DEFAULT : view;
    }

    @Override
    public StringQueryDefinition newStringDefinition() {
        return new StringQueryDefinitionImpl(null);
    }

    @Override
    public StringQueryDefinition newStringDefinition(String optionsName) {
        return new StringQueryDefinitionImpl(optionsName);
    }

    @Override
    public StructuredQueryBuilder newStructuredQueryBuilder() {
        return new StructuredQueryBuilder();
    }

    @Override
    public StructuredQueryBuilder newStructuredQueryBuilder(String optionsName) {
        return new StructuredQueryBuilder(optionsName);
    }

    @Override
    public DeleteQueryDefinition newDeleteDefinition() {
        return new DeleteQueryDefinitionImpl();
    }

    @Override
    public ValuesDefinition newValuesDefinition(String name) {
        return new ValuesDefinitionImpl(name, null);
    }

    @Override
    public ValuesDefinition newValuesDefinition(String name, String optionsName) {
        return new ValuesDefinitionImpl(name, optionsName);
    }

    @Override
    public ValuesListDefinition newValuesListDefinition() {
        return new ValuesListDefinitionImpl(null);
    }

    @Override
    public ValuesListDefinition newValuesListDefinition(String optionsName) {
        return new ValuesListDefinitionImpl(optionsName);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle) {
        return this.search(querydef, searchHandle, 1L, null, null);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, String forestName) {
        return this.search(querydef, searchHandle, 1L, null, forestName);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, long start) {
        return this.search(querydef, searchHandle, start, null, null);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, long start, String forestName) {
        return this.search(querydef, searchHandle, start, null, forestName);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, Transaction transaction) {
        return this.search(querydef, searchHandle, 1L, transaction, null);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, Transaction transaction, String forestName) {
        return this.search(querydef, searchHandle, 1L, transaction, forestName);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, long start, Transaction transaction) {
        return this.search(querydef, searchHandle, start, transaction, null);
    }

    @Override
    public <T extends SearchReadHandle> T search(SearchQueryDefinition querydef, T searchHandle, long start, Transaction transaction, String forestName) {
        if (searchHandle instanceof SearchHandle) {
            SearchHandle responseHandle = (SearchHandle)searchHandle;
            responseHandle.setHandleRegistry(this.getHandleRegistry());
            responseHandle.setQueryCriteria(querydef);
        }
        return this.services.search(this.requestLogger, searchHandle, querydef, start, this.pageLen, this.view, transaction, forestName);
    }

    public <T extends UrisReadHandle> T uris(String method, SearchQueryDefinition querydef, Boolean filtered, T urisHandle, long start, String afterUri, String forestName) {
        return this.services.uris(this.requestLogger, method, querydef, filtered, start, afterUri, this.pageLen, forestName, urisHandle);
    }

    @Override
    public void delete(DeleteQueryDefinition querydef) {
        this.delete(querydef, null);
    }

    @Override
    public void delete(DeleteQueryDefinition querydef, Transaction transaction) {
        this.services.deleteSearch(this.requestLogger, querydef, transaction);
    }

    @Override
    public <T extends ValuesReadHandle> T values(ValuesDefinition valdef, T valueHandle) {
        return this.values(valdef, valueHandle, -1L, null);
    }

    @Override
    public <T extends ValuesReadHandle> T values(ValuesDefinition valdef, T valueHandle, long start) {
        return this.values(valdef, valueHandle, start, null);
    }

    @Override
    public <T extends ValuesReadHandle> T values(ValuesDefinition valdef, T valueHandle, Transaction transaction) {
        return this.values(valdef, valueHandle, -1L, transaction);
    }

    @Override
    public <T extends ValuesReadHandle> T values(ValuesDefinition valdef, T valueHandle, long start, Transaction transaction) {
        HandleImplementation valuesBase = HandleAccessor.checkHandle(valueHandle, "values");
        if (valueHandle instanceof ValuesHandle) {
            ((ValuesHandle)valueHandle).setQueryCriteria(valdef);
        }
        Format valuesFormat = valuesBase.getFormat();
        switch (valuesFormat) {
            case UNKNOWN: {
                valuesFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON values results are possible.");
            }
        }
        String mimetype = valuesFormat.getDefaultMimetype();
        long pageLength = start == -1L ? -1L : this.getPageLength();
        String tid = transaction == null ? null : transaction.getTransactionId();
        valuesBase.receiveContent(this.services.values(valuesBase.receiveAs(), valdef, mimetype, start, pageLength, transaction));
        return valueHandle;
    }

    @Override
    public <T extends TuplesReadHandle> T tuples(ValuesDefinition valdef, T tupleHandle) {
        return this.tuples(valdef, tupleHandle, -1L, null);
    }

    @Override
    public <T extends TuplesReadHandle> T tuples(ValuesDefinition valdef, T tupleHandle, long start) {
        return this.tuples(valdef, tupleHandle, start, null);
    }

    @Override
    public <T extends TuplesReadHandle> T tuples(ValuesDefinition valdef, T tupleHandle, Transaction transaction) {
        return this.tuples(valdef, tupleHandle, -1L, transaction);
    }

    @Override
    public <T extends TuplesReadHandle> T tuples(ValuesDefinition valdef, T tupleHandle, long start, Transaction transaction) {
        HandleImplementation valuesBase = HandleAccessor.checkHandle(tupleHandle, "values");
        if (tupleHandle instanceof TuplesHandle) {
            ((TuplesHandle)tupleHandle).setQueryCriteria(valdef);
        }
        Format valuesFormat = valuesBase.getFormat();
        switch (valuesFormat) {
            case UNKNOWN: {
                valuesFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON values results are possible.");
            }
        }
        String mimetype = valuesFormat.getDefaultMimetype();
        long pageLength = start == -1L ? -1L : this.getPageLength();
        String tid = transaction == null ? null : transaction.getTransactionId();
        valuesBase.receiveContent(this.services.values(valuesBase.receiveAs(), valdef, mimetype, start, pageLength, transaction));
        return tupleHandle;
    }

    @Override
    public <T extends ValuesListReadHandle> T valuesList(ValuesListDefinition valdef, T valueHandle) {
        return this.valuesList(valdef, valueHandle, null);
    }

    @Override
    public <T extends ValuesListReadHandle> T valuesList(ValuesListDefinition valdef, T valuesHandle, Transaction transaction) {
        HandleImplementation valuesBase = HandleAccessor.checkHandle(valuesHandle, "valueslist");
        Format valuesFormat = valuesBase.getFormat();
        switch (valuesFormat) {
            case UNKNOWN: {
                valuesFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON values list results are possible.");
            }
        }
        String mimetype = valuesFormat.getDefaultMimetype();
        String tid = transaction == null ? null : transaction.getTransactionId();
        valuesBase.receiveContent(this.services.valuesList(valuesBase.receiveAs(), valdef, mimetype, transaction));
        return valuesHandle;
    }

    @Override
    public <T extends QueryOptionsListReadHandle> T optionsList(T optionsHandle) {
        return this.optionsList(optionsHandle, null);
    }

    @Override
    public <T extends QueryOptionsListReadHandle> T optionsList(T optionsHandle, Transaction transaction) {
        HandleImplementation optionsBase = HandleAccessor.checkHandle(optionsHandle, "optionslist");
        Format optionsFormat = optionsBase.getFormat();
        switch (optionsFormat) {
            case UNKNOWN: {
                optionsFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON options list results are possible.");
            }
        }
        String mimetype = optionsFormat.getDefaultMimetype();
        String tid = transaction == null ? null : transaction.getTransactionId();
        optionsBase.receiveContent(this.services.optionsList(optionsBase.receiveAs(), mimetype, transaction));
        return optionsHandle;
    }

    @Override
    public MatchDocumentSummary findOne(QueryDefinition querydef) {
        SearchHandle results = this.search(querydef, new SearchHandle());
        MatchDocumentSummary[] summaries = results.getMatchResults();
        if (summaries.length > 0) {
            return summaries[0];
        }
        return null;
    }

    @Override
    public MatchDocumentSummary findOne(QueryDefinition querydef, Transaction transaction) {
        SearchHandle results = this.search((SearchQueryDefinition)querydef, new SearchHandle(), transaction);
        MatchDocumentSummary[] summaries = results.getMatchResults();
        if (summaries.length > 0) {
            return summaries[0];
        }
        return null;
    }

    @Override
    public String[] suggest(SuggestDefinition suggestDef) {
        DOMHandle handle = new DOMHandle();
        HandleImplementation suggestBase = HandleAccessor.checkHandle(handle, "suggest");
        suggestBase.receiveContent(this.services.suggest(suggestBase.receiveAs(), suggestDef));
        Document doc = handle.get();
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            suggestions.add(nodeList.item(i).getTextContent());
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }

    @Override
    public <T extends StructureReadHandle> T convert(RawQueryByExampleDefinition query, T convertedHandle) {
        return this.convertOrValidate(query, convertedHandle, "structured");
    }

    @Override
    public <T extends StructureReadHandle> T validate(RawQueryByExampleDefinition query, T convertedHandle) {
        return this.convertOrValidate(query, convertedHandle, "validate");
    }

    @Override
    public CtsQueryBuilder newCtsSearchBuilder() {
        return new CtsQueryBuilderImpl();
    }

    private <T extends StructureReadHandle> T convertOrValidate(RawQueryByExampleDefinition query, T convertedHandle, String view) {
        String optionsName;
        HandleImplementation queryBase;
        if (convertedHandle == null) {
            throw new IllegalArgumentException("null handle for query");
        }
        RequestParameters params = new RequestParameters();
        params.add("view", view);
        HandleImplementation convertedBase = HandleAccessor.checkHandle(convertedHandle, "convert");
        StructureWriteHandle queryHandle = query.getHandle();
        Format convertedFormat = convertedBase.getFormat();
        if (convertedFormat == Format.UNKNOWN && queryHandle != null && (queryBase = HandleAccessor.checkHandle(queryHandle, "validate")).getFormat() == Format.UNKNOWN) {
            convertedBase.setFormat(Format.XML);
        }
        if ((optionsName = query.getOptionsName()) != null && optionsName.length() > 0) {
            params.add("options", optionsName);
        }
        this.services.postResource(this.requestLogger, "qbe", null, params, queryHandle, convertedHandle);
        return convertedHandle;
    }

    @Override
    public SuggestDefinition newSuggestDefinition() {
        SuggestDefinitionImpl def = new SuggestDefinitionImpl();
        return def;
    }

    @Override
    public SuggestDefinition newSuggestDefinition(String optionsName) {
        SuggestDefinitionImpl def = new SuggestDefinitionImpl();
        def.setStringCriteria("");
        def.setOptionsName(optionsName);
        return def;
    }

    @Override
    public SuggestDefinition newSuggestDefinition(String suggestString, String optionsName) {
        SuggestDefinitionImpl def = new SuggestDefinitionImpl();
        def.setStringCriteria(suggestString);
        def.setOptionsName(optionsName);
        return def;
    }

    @Override
    public RawCombinedQueryDefinition newRawCombinedQueryDefinitionAs(Format format, Object rawQuery) {
        return this.newRawCombinedQueryDefinitionAs(format, rawQuery, null);
    }

    @Override
    public RawCombinedQueryDefinition newRawCombinedQueryDefinitionAs(Format format, Object rawQuery, String optionsName) {
        return this.newRawCombinedQueryDefinition(this.structuredWrite(format, rawQuery), optionsName);
    }

    @Override
    public RawCombinedQueryDefinition newRawCombinedQueryDefinition(StructureWriteHandle handle) {
        return new RawQueryDefinitionImpl.Combined(handle);
    }

    @Override
    public RawCombinedQueryDefinition newRawCombinedQueryDefinition(StructureWriteHandle handle, String optionsName) {
        return new RawQueryDefinitionImpl.Combined(handle, optionsName);
    }

    @Override
    public RawStructuredQueryDefinition newRawStructuredQueryDefinitionAs(Format format, Object query) {
        return this.newRawStructuredQueryDefinitionAs(format, query, null);
    }

    @Override
    public RawStructuredQueryDefinition newRawStructuredQueryDefinitionAs(Format format, Object query, String optionsName) {
        return this.newRawStructuredQueryDefinition(this.structuredWrite(format, query), optionsName);
    }

    @Override
    public RawStructuredQueryDefinition newRawStructuredQueryDefinition(StructureWriteHandle handle) {
        return new RawQueryDefinitionImpl.Structured(handle);
    }

    @Override
    public RawStructuredQueryDefinition newRawStructuredQueryDefinition(StructureWriteHandle handle, String optionsName) {
        return new RawQueryDefinitionImpl.Structured(handle, optionsName);
    }

    @Override
    public RawCtsQueryDefinition newRawCtsQueryDefinitionAs(Format format, Object query) {
        return this.newRawCtsQueryDefinitionAs(format, query, null);
    }

    @Override
    public RawCtsQueryDefinition newRawCtsQueryDefinitionAs(Format format, Object query, String optionsName) {
        return this.newRawCtsQueryDefinition(this.ctsQueryWrite(format, query), optionsName);
    }

    @Override
    public RawCtsQueryDefinition newRawCtsQueryDefinition(CtsQueryWriteHandle handle) {
        return new RawQueryDefinitionImpl.CtsQuery(handle);
    }

    @Override
    public RawCtsQueryDefinition newRawCtsQueryDefinition(CtsQueryWriteHandle handle, String optionsName) {
        return new RawQueryDefinitionImpl.CtsQuery(handle, optionsName);
    }

    @Override
    public RawQueryByExampleDefinition newRawQueryByExampleDefinitionAs(Format format, Object query) {
        return this.newRawQueryByExampleDefinitionAs(format, query, null);
    }

    @Override
    public RawQueryByExampleDefinition newRawQueryByExampleDefinitionAs(Format format, Object query, String optionsName) {
        return this.newRawQueryByExampleDefinition(this.structuredWrite(format, query), optionsName);
    }

    @Override
    public RawQueryByExampleDefinition newRawQueryByExampleDefinition(StructureWriteHandle handle) {
        return new RawQueryDefinitionImpl.ByExample(handle);
    }

    @Override
    public RawQueryByExampleDefinition newRawQueryByExampleDefinition(StructureWriteHandle handle, String optionsName) {
        return new RawQueryDefinitionImpl.ByExample(handle, optionsName);
    }

    private StructureWriteHandle structuredWrite(Format format, Object query) {
        Class<?> as = query.getClass();
        ContentHandle<?> queryHandle = this.getHandleRegistry().makeHandle(as);
        if (!StructureWriteHandle.class.isAssignableFrom(queryHandle.getClass())) {
            throw new IllegalArgumentException("Handle " + queryHandle.getClass().getName() + " does not provide structure write handle for " + as.getName());
        }
        Utilities.setHandleContent(queryHandle, query);
        Utilities.setHandleStructuredFormat(queryHandle, format);
        return (StructureWriteHandle)((Object)queryHandle);
    }

    private CtsQueryWriteHandle ctsQueryWrite(Format format, Object query) {
        Class<?> as = query.getClass();
        ContentHandle<?> queryHandle = this.getHandleRegistry().makeHandle(as);
        if (!CtsQueryWriteHandle.class.isAssignableFrom(queryHandle.getClass())) {
            throw new IllegalArgumentException("Handle " + queryHandle.getClass().getName() + " does not provide a CtsQueryWriteHandle for " + as.getName());
        }
        Utilities.setHandleContent(queryHandle, query);
        Utilities.setHandleStructuredFormat(queryHandle, format);
        return (CtsQueryWriteHandle)((Object)queryHandle);
    }
}

