/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamTee
extends OutputStream {
    private OutputStream out;
    private OutputStream tee;
    private long max = 0L;
    private long sent = 0L;

    public OutputStreamTee(OutputStream out, OutputStream tee, long max) {
        this.out = out;
        this.tee = tee;
        this.max = max;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out == null) {
            throw new IOException("Output Stream closed");
        }
        this.out.write(b);
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(b);
            return;
        }
        if (this.sent >= this.max) {
            return;
        }
        this.tee.write(b);
        ++this.sent;
        if (this.sent == this.max) {
            this.cleanupTee();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.out == null) {
            throw new IOException("Output Stream closed");
        }
        this.out.write(b);
        this.writeTee(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException("Output Stream closed");
        }
        this.out.write(b, off, len);
        this.writeTee(b, off, len);
    }

    private void writeTee(byte[] b, int off, int len) throws IOException {
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(b, off, len);
            return;
        }
        if (this.sent >= this.max) {
            return;
        }
        int teeLen = this.sent + (long)len <= this.max ? len : (int)(this.max - this.sent);
        this.sent += (long)teeLen;
        this.tee.write(b, off, teeLen);
        if (this.sent >= this.max) {
            this.cleanupTee();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.flush();
        if (this.tee != null) {
            this.tee.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        this.cleanupTee();
    }

    private void cleanupTee() throws IOException {
        if (this.tee == null) {
            return;
        }
        this.tee.flush();
        this.tee = null;
    }
}

