/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public abstract class JacksonBaseHandle<T>
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender {
    private ObjectMapper mapper;

    protected JacksonBaseHandle() {
        super.setFormat(Format.JSON);
    }

    public ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            this.mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        }
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public abstract T get();

    public abstract void set(T var1);

    public abstract T toContent(InputStream var1);

    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.set(null);
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    public byte[] toBuffer() {
        byte[] b = this.contentToBytes(this.get());
        if (!this.isResendable()) {
            this.fromBuffer(b);
        }
        return b;
    }

    public T bytesToContent(byte[] buffer) {
        return this.toContent(new ByteArrayInputStream(buffer));
    }

    public byte[] contentToBytes(T content) {
        try {
            if (!this.hasContent()) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.sendContent(content).write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    protected abstract OutputStreamSender sendContent(T var1);

    protected abstract boolean hasContent();
}

