/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.document.DocumentPatchBuilder;
import java.io.CharArrayWriter;

public class JSONStringWriter {
    private StringBuilder builder;
    private boolean isFirst = false;
    private DocumentPatchBuilder.PathLanguage pathLang;

    JSONStringWriter(DocumentPatchBuilder.PathLanguage pathLang) {
        this.pathLang = pathLang;
        this.builder = new StringBuilder();
    }

    public DocumentPatchBuilder.PathLanguage getPathLanguage() {
        return this.pathLang;
    }

    public void writeStartObject() {
        this.builder.append("{");
        this.isFirst = true;
    }

    public void writeStartObjectInLoop() {
        if (this.isFirst) {
            this.isFirst = false;
        } else {
            this.builder.append(", ");
        }
        this.writeStartObject();
    }

    public void writeStartEntry(String key) {
        if (this.isFirst) {
            this.isFirst = false;
        } else {
            this.builder.append(", ");
        }
        this.builder.append(JSONStringWriter.toJSON(key));
        this.builder.append(":");
    }

    public void writeEndObject() {
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.builder.append("}");
    }

    public void writeStartArray() {
        this.builder.append("[");
        this.isFirst = true;
    }

    public void writeStartItem() {
        if (this.isFirst) {
            this.isFirst = false;
        } else {
            this.builder.append(", ");
        }
    }

    public void writeEndArray() {
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.builder.append("]");
    }

    public void writeFragment(String fragment) {
        this.builder.append(fragment);
    }

    public void writeStringValue(Object value) {
        this.builder.append(JSONStringWriter.toJSON(value));
    }

    public void writeNumberValue(Object value) {
        this.builder.append(value);
    }

    public void writeBooleanValue(Object value) {
        this.builder.append(value);
    }

    public String toString() {
        return this.builder.toString();
    }

    public static String toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        String str = value instanceof String ? (String)value : value.toString();
        return JSONStringWriter.toJSON(str);
    }

    public static String toJSON(String value) {
        int valen = value.length();
        CharArrayWriter out = new CharArrayWriter(valen + 2);
        out.append('\"');
        block9: for (int i = 0; i < valen; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block9;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block9;
                }
                case '\b': {
                    out.append('\\');
                    out.append('b');
                    continue block9;
                }
                case '\f': {
                    out.append('\\');
                    out.append('f');
                    continue block9;
                }
                case '\n': {
                    out.append('\\');
                    out.append('n');
                    continue block9;
                }
                case '\r': {
                    out.append('\\');
                    out.append('r');
                    continue block9;
                }
                case '\t': {
                    out.append('\\');
                    out.append('t');
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        out.append(String.format("\\u%1$04x", ch));
                        continue block9;
                    }
                    out.append(ch);
                }
            }
        }
        out.append('\"');
        return out.toString();
    }
}

