/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.FailedRequestParser;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JSONErrorParser;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FailedRequest {
    private static final String ERROR_NS = "http://marklogic.com/xdmp/error";
    private String messageCode;
    private String messageString;
    private int statusCode;
    private String statusString;
    private String stackTrace;

    public static FailedRequest getFailedRequest(int httpStatus, String contentType, InputStream content) {
        FailedRequest failure = null;
        if (contentType != null) {
            Format format = Format.getFromMimetype(contentType);
            switch (format) {
                case XML: {
                    failure = FailedRequest.xmlFailedRequest(httpStatus, content);
                    break;
                }
                case JSON: {
                    failure = FailedRequest.jsonFailedRequest(httpStatus, content);
                }
            }
        } else if (httpStatus == 404) {
            failure = new FailedRequest();
            failure.setStatusCode(httpStatus);
            failure.setMessageString("");
            failure.setStatusString("Not Found");
        }
        if (failure == null) {
            failure = new FailedRequest();
            failure.setStatusCode(httpStatus);
            failure.setMessageCode("UNKNOWN");
            failure.setMessageString("Server (not a REST instance?) did not respond with an expected REST Error message.");
            failure.setStatusString("UNKNOWN");
        }
        if (failure.getStatusCode() == 401) {
            failure.setMessageString("Unauthorized");
            failure.setStatusString("Failed Auth");
        }
        return failure;
    }

    private static FailedRequest xmlFailedRequest(int httpStatus, InputStream content) {
        return new FailedRequestXMLParser().parseFailedRequest(httpStatus, content);
    }

    private static FailedRequest jsonFailedRequest(int httpStatus, InputStream content) {
        return new JSONErrorParser().parseFailedRequest(httpStatus, content);
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getMessage() {
        return this.messageString;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    private static class FailedRequestXMLParser
    implements FailedRequestParser {
        private FailedRequestXMLParser() {
        }

        @Override
        public FailedRequest parseFailedRequest(int httpStatus, InputStream is) {
            FailedRequest failure = new FailedRequest();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                NodeList messageCodes;
                int parsedStatusCode;
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                String statusCode = null;
                NodeList statusCodes = doc.getElementsByTagNameNS(FailedRequest.ERROR_NS, "status-code");
                if (statusCodes != null && statusCodes.getLength() > 0) {
                    statusCode = statusCodes.item(0).getTextContent();
                }
                failure.setStatusCode((parsedStatusCode = Utilities.parseInt(statusCode)) > 0 ? parsedStatusCode : httpStatus);
                NodeList statuses = doc.getElementsByTagNameNS(FailedRequest.ERROR_NS, "status");
                if (statuses != null && statuses.getLength() > 0) {
                    failure.setStatusString(statuses.item(0).getTextContent());
                }
                if ((messageCodes = doc.getElementsByTagNameNS(FailedRequest.ERROR_NS, "message-code")) != null && messageCodes.getLength() > 0) {
                    failure.setMessageCode(messageCodes.item(0).getTextContent());
                }
                String formatString = null;
                NodeList formatStrings = doc.getElementsByTagNameNS(FailedRequest.ERROR_NS, "format-string");
                if (formatStrings != null && formatStrings.getLength() > 0) {
                    formatString = formatStrings.item(0).getTextContent();
                }
                if (formatString != null) {
                    failure.setMessageString(formatString);
                } else {
                    NodeList messageStrings = doc.getElementsByTagNameNS(FailedRequest.ERROR_NS, "message");
                    if (messageStrings != null && messageStrings.getLength() > 0) {
                        failure.setMessageString(messageStrings.item(0).getTextContent());
                    }
                }
            }
            catch (ParserConfigurationException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error.");
            }
            catch (SAXException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error details");
            }
            catch (IOException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Error body not received from server");
            }
            return failure;
        }
    }
}

