/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class GSONHandle
extends BaseHandle<InputStream, String>
implements ResendableContentHandle<JsonElement, InputStream>,
JSONReadHandle,
JSONWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private JsonElement content;
    private JsonParser parser;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonElement.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonElement.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                GSONHandle handle = this.isHandled(type) ? new GSONHandle() : null;
                return handle;
            }
        };
    }

    public GSONHandle() {
        this.setResendable(true);
        super.setFormat(Format.JSON);
    }

    public GSONHandle(JsonElement content) {
        this();
        this.set(content);
    }

    @Override
    public GSONHandle newHandle() {
        return new GSONHandle();
    }

    public GSONHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new GSONHandle[length];
    }

    public JsonParser getParser() {
        if (this.parser == null) {
            this.parser = new JsonParser();
        }
        return this.parser;
    }

    @Override
    public JsonElement get() {
        return this.content;
    }

    @Override
    public void set(JsonElement content) {
        this.content = content;
    }

    public GSONHandle with(JsonElement content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<JsonElement> getContentClass() {
        return JsonElement.class;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.JSON) {
            throw new IllegalArgumentException("GSONHandle supports the JSON format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public JsonElement bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(JsonElement content) {
        return content == null ? null : content.toString().getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        if (this.content == null) {
            return "";
        }
        return this.content.toString();
    }

    @Override
    public JsonElement toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8));
            return jsonElement;
        }
        catch (JsonIOException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonSyntaxException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream serialization) {
        this.set(this.toContent(serialization));
    }

    @Override
    protected String sendContent() {
        return this.sendContent(this.get());
    }

    private String sendContent(JsonElement content) {
        if (content == null) {
            throw new IllegalStateException("No document to write");
        }
        return content.toString();
    }
}

