/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.dom4j;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class DOM4JHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements ResendableContentHandle<Document, InputStream>,
OutputStreamSender,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private SAXReader reader;
    private OutputFormat outputFormat;
    private Document content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                DOM4JHandle handle = this.isHandled(type) ? new DOM4JHandle() : null;
                return handle;
            }
        };
    }

    public DOM4JHandle() {
        this.setResendable(true);
        super.setFormat(Format.XML);
    }

    public DOM4JHandle(Document content) {
        this();
        this.set(content);
    }

    @Override
    public DOM4JHandle newHandle() {
        return new DOM4JHandle();
    }

    public DOM4JHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new DOM4JHandle[length];
    }

    public SAXReader getReader() {
        if (this.reader == null) {
            this.reader = this.makeReader();
        }
        return this.reader;
    }

    public void setReader(SAXReader reader) {
        this.reader = reader;
    }

    protected SAXReader makeReader() {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        reader.setValidation(false);
        return reader;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public DOM4JHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<Document> getContentClass() {
        return Document.class;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JDOMHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public Document bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(Document content) {
        try {
            if (content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.sendContent(content).write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    public Document toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            Document document = this.getReader().read((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8));
            return document;
        }
        catch (DocumentException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream serialization) {
        this.set(this.toContent(serialization));
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this.sendContent(this.get());
    }

    private OutputStreamSender sendContent(Document content) {
        return new OutputStreamSenderImpl(this.getOutputFormat(), content);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final OutputFormat outputFormat;
        private final Document content;

        private OutputStreamSenderImpl(OutputFormat outputFormat, Document content) {
            if (content == null) {
                throw new IllegalStateException("No document to write");
            }
            this.outputFormat = outputFormat;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            if (this.outputFormat != null) {
                new XMLWriter((Writer)writer, this.outputFormat).write(this.content);
            } else {
                new XMLWriter((Writer)writer).write(this.content);
            }
            ((Writer)writer).flush();
        }
    }
}

