/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriMakerImpl<T extends AbstractWriteHandle>
implements Splitter.UriMaker {
    private String inputAfter;
    private String inputName;
    private String extension;
    private String name;

    @Override
    public String getInputAfter() {
        return this.inputAfter;
    }

    @Override
    public void setInputAfter(String base) {
        this.inputAfter = base;
    }

    @Override
    public String getSplitFilename() {
        return this.inputName;
    }

    @Override
    public void setSplitFilename(String name) {
        this.inputName = name;
        this.setExtensionAndName();
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getName() {
        return this.name;
    }

    public void setExtensionAndName() {
        if (this.getSplitFilename() == null || this.getSplitFilename().length() == 0) {
            return;
        }
        Pattern extensionRegex = Pattern.compile("^(.*)\\.([^.]*)$");
        Matcher matcher = extensionRegex.matcher(this.getSplitFilename());
        boolean found = matcher.find();
        if (!found) {
            this.name = this.getSplitFilename();
            this.extension = null;
        } else {
            this.name = matcher.group(1);
            this.extension = matcher.group(2);
        }
    }

    public String makeUri(long num, T handle) {
        StringBuilder uri = new StringBuilder();
        if (this.getInputAfter() != null && this.getInputAfter().length() != 0) {
            uri.append(this.getInputAfter());
        }
        if (this.getSplitFilename() != null && this.getSplitFilename().length() != 0) {
            uri.append(this.getName());
        }
        if (uri.length() == 0) {
            uri.append("/");
        }
        uri.append(num).append("_").append(UUID.randomUUID()).append(".").append(this.getExtension());
        return uri.toString();
    }
}

