/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.QueryFailureListener;
import com.marklogic.client.datamovement.WriteBatchListener;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.WriteFailureListener;
import com.marklogic.client.datamovement.impl.BatcherImpl;
import com.marklogic.client.datamovement.impl.JobTicketImpl;
import com.marklogic.client.datamovement.impl.QueryJobReportListener;
import com.marklogic.client.datamovement.impl.WriteJobReportListener;
import java.util.Calendar;

public class JobReportImpl
implements JobReport {
    private long successEventsCount = 0L;
    private long failureEventsCount = 0L;
    private long successBatchesCount = 0L;
    private long failureBatchesCount = 0L;
    private boolean isJobComplete;
    private Calendar jobStartTime;
    private Calendar jobEndTime;
    private Calendar reportTimestamp;

    public static JobReportImpl about(JobTicketImpl ticket) {
        BatcherImpl batcher = ticket.getBatcher();
        JobTicket.JobType jobType = ticket.getJobType();
        if (jobType == null) {
            throw new InternalError("null job type");
        }
        switch (jobType) {
            case QUERY_BATCHER: {
                return new JobReportImpl((QueryBatcher)((Object)batcher));
            }
            case WRITE_BATCHER: {
                return new JobReportImpl((WriteBatcher)((Object)batcher));
            }
        }
        throw new InternalError("unknown job type: " + jobType.name());
    }

    public JobReportImpl(WriteBatcher batcher) {
        WriteFailureListener[] failureListeners;
        WriteBatchListener[] batchListeners;
        WriteJobReportListener writeJobSuccessListener = null;
        WriteJobReportListener writeJobFailureListener = null;
        for (WriteBatchListener batchListener : batchListeners = batcher.getBatchSuccessListeners()) {
            if (!(batchListener instanceof WriteJobReportListener)) continue;
            writeJobSuccessListener = (WriteJobReportListener)batchListener;
            break;
        }
        for (WriteFailureListener failureListener : failureListeners = batcher.getBatchFailureListeners()) {
            if (!(failureListener instanceof WriteJobReportListener)) continue;
            writeJobFailureListener = (WriteJobReportListener)failureListener;
            break;
        }
        if (writeJobSuccessListener == null || writeJobFailureListener == null) {
            throw new IllegalStateException("WriteJobReportListener should be registered in both the Success and Failure Listeners");
        }
        if (writeJobSuccessListener != writeJobFailureListener) {
            throw new IllegalStateException("The same WriteJobReportListener should be registered in both the Success and Failure Listeners");
        }
        this.successBatchesCount = writeJobSuccessListener.getSuccessBatchesCount();
        this.failureBatchesCount = writeJobSuccessListener.getFailureBatchesCount();
        this.successEventsCount = writeJobSuccessListener.getSuccessEventsCount();
        this.failureEventsCount = writeJobSuccessListener.getFailureEventsCount();
        this.isJobComplete = batcher.isStopped();
        this.reportTimestamp = Calendar.getInstance();
        this.jobStartTime = batcher.getJobStartTime();
        this.jobEndTime = batcher.getJobEndTime();
    }

    public JobReportImpl(QueryBatcher batcher) {
        QueryFailureListener[] failureListeners;
        QueryBatchListener[] batchListeners;
        QueryJobReportListener queryJobSuccessListener = null;
        QueryJobReportListener queryJobFailureListener = null;
        for (QueryBatchListener batchListener : batchListeners = batcher.getQuerySuccessListeners()) {
            if (!(batchListener instanceof QueryJobReportListener)) continue;
            queryJobSuccessListener = (QueryJobReportListener)batchListener;
            break;
        }
        for (QueryFailureListener failureListener : failureListeners = batcher.getQueryFailureListeners()) {
            if (!(failureListener instanceof QueryJobReportListener)) continue;
            queryJobFailureListener = (QueryJobReportListener)failureListener;
            break;
        }
        if (queryJobSuccessListener == null || queryJobFailureListener == null) {
            throw new IllegalStateException("QueryJobReportListener should be registered in both the Success and Failure Listeners");
        }
        if (queryJobSuccessListener != queryJobFailureListener) {
            throw new IllegalStateException("The same QueryJobReportListener should be registered in both the Success and Failure Listeners");
        }
        this.successBatchesCount = queryJobSuccessListener.getSuccessBatchesCount();
        this.failureEventsCount = this.failureBatchesCount = queryJobSuccessListener.getFailureBatchesCount();
        this.successEventsCount = queryJobSuccessListener.getSuccessEventsCount();
        this.isJobComplete = batcher.isStopped();
        this.reportTimestamp = Calendar.getInstance();
        this.jobStartTime = batcher.getJobStartTime();
        this.jobEndTime = batcher.getJobEndTime();
    }

    @Override
    public long getSuccessEventsCount() {
        return this.successEventsCount;
    }

    @Override
    public long getFailureEventsCount() {
        return this.failureEventsCount;
    }

    @Override
    public long getSuccessBatchesCount() {
        return this.successBatchesCount;
    }

    @Override
    public long getFailureBatchesCount() {
        return this.failureBatchesCount;
    }

    public boolean isJobComplete() {
        return this.isJobComplete;
    }

    @Override
    public Calendar getReportTimestamp() {
        return this.reportTimestamp;
    }

    @Override
    public Calendar getJobStartTime() {
        return this.jobStartTime;
    }

    @Override
    public Calendar getJobEndTime() {
        return this.jobEndTime;
    }
}

