/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRateLimiter
extends AbstractRateLimiter {
    private static Logger log = LoggerFactory.getLogger(ConsulRateLimiter.class);
    private final ConsulClient consulClient;
    private final ObjectMapper objectMapper;

    public ConsulRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, ConsulClient consulClient, ObjectMapper objectMapper) {
        super(rateLimiterErrorHandler);
        this.consulClient = consulClient;
        this.objectMapper = objectMapper;
    }

    @Override
    protected Rate getRate(String key) {
        Rate rate = null;
        GetValue value = (GetValue)this.consulClient.getKVValue(this.buildValidConsulKey(key)).getValue();
        if (value != null && value.getDecodedValue() != null) {
            try {
                rate = (Rate)this.objectMapper.readValue(value.getDecodedValue(), Rate.class);
            }
            catch (IOException e) {
                log.error("Failed to deserialize Rate", (Throwable)e);
            }
        }
        return rate;
    }

    @Override
    protected void saveRate(Rate rate) {
        String value = "";
        try {
            value = this.objectMapper.writeValueAsString((Object)rate);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize Rate", (Throwable)e);
        }
        if (org.springframework.util.StringUtils.hasText((String)value)) {
            this.consulClient.setKVValue(this.buildValidConsulKey(rate.getKey()), value);
        }
    }

    private String buildValidConsulKey(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return key.replaceAll("/", "_");
        }
        return key;
    }
}

