/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.models;

import com.mapbox.services.Constants;
import java.util.logging.Logger;

public class Position {
    private static final Logger logger = Logger.getLogger(Position.class.getSimpleName());
    private final double longitude;
    private final double latitude;
    private final double altitude;

    private Position(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
        if (latitude < -90.0 || latitude > 90.0) {
            logger.warning(String.format(Constants.DEFAULT_LOCALE, "Latitude value seems to be out of range (found: %f, expected: [-90, 90]). Did you accidentally reverse the longitude/latitude order?", latitude));
        }
        if (longitude < -180.0 || longitude > 180.0) {
            logger.warning(String.format(Constants.DEFAULT_LOCALE, "Longitude value seems to be out of range (found: %f, expected: [-180, 180]). Did you accidentally reverse the longitude/latitude order?", longitude));
        }
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double[] getCoordinates() {
        if (this.hasAltitude()) {
            return new double[]{this.getLongitude(), this.getLatitude(), this.getAltitude()};
        }
        return new double[]{this.getLongitude(), this.getLatitude()};
    }

    public static Position fromCoordinates(double longitude, double latitude, double altitude) {
        return new Position(longitude, latitude, altitude);
    }

    public static Position fromCoordinates(double longitude, double latitude) {
        return new Position(longitude, latitude, Double.NaN);
    }

    public static Position fromCoordinates(double[] coordinates) {
        if (coordinates.length == 3) {
            return Position.fromCoordinates(coordinates[0], coordinates[1], coordinates[2]);
        }
        return Position.fromCoordinates(coordinates[0], coordinates[1]);
    }

    public static Position fromLngLat(double longitude, double latitude) {
        return Position.fromCoordinates(longitude, latitude);
    }

    public boolean hasAltitude() {
        return !Double.isNaN(this.altitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Position)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Position position = (Position)obj;
        if (position.getLatitude() != this.latitude) {
            return false;
        }
        if (position.getLongitude() != this.longitude) {
            return false;
        }
        if (Double.isNaN(position.getAltitude()) != Double.isNaN(this.altitude)) {
            return false;
        }
        return Double.isNaN(this.altitude) || position.getAltitude() == this.altitude;
    }

    public String toString() {
        return "Position [longitude=" + this.longitude + ", latitude=" + this.latitude + ", altitude=" + this.altitude + "]";
    }
}

