/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics;

import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.core.metrics.AbstractCompositeMetrics;
import com.mapbox.android.core.metrics.Metrics;
import com.mapbox.android.core.metrics.MetricsImpl;

public class TelemetryMetrics
extends AbstractCompositeMetrics {
    public static final String EVENTS_TOTAL = "eventCountTotal";
    public static final String EVENTS_FAILED = "eventCountFailed";
    @VisibleForTesting
    static final String MOBILE_BYTES_TX = "cellDataSent";
    static final String WIFI_BYTES_TX = "wifiDataSent";
    static final String MOBILE_BYTES_RX = "cellDataReceived";
    static final String WIFI_BYTES_RX = "wifiDataReceived";

    public TelemetryMetrics(long maxLength) {
        super(maxLength);
    }

    public void addRxBytesForType(@IntRange(from=0L, to=17L) int networkType, long bytes) {
        if (TelemetryMetrics.isValidNetworkType(networkType)) {
            this.add(networkType == 1 ? WIFI_BYTES_RX : MOBILE_BYTES_RX, bytes);
        }
    }

    public void addTxBytesForType(@IntRange(from=0L, to=17L) int networkType, long bytes) {
        if (TelemetryMetrics.isValidNetworkType(networkType)) {
            this.add(networkType == 1 ? WIFI_BYTES_TX : MOBILE_BYTES_TX, bytes);
        }
    }

    protected Metrics nextMetrics(long start, long end) {
        return new MetricsImpl(start, end);
    }

    private static boolean isValidNetworkType(int type) {
        return type >= 0 && type <= 17;
    }
}

