/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import androidx.annotation.NonNull;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Clock;
import com.mapbox.android.telemetry.ConfigurationClient;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.FullQueueCallback;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientFactory;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.android.telemetry.errors.ErrorReporterEngine;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class MapboxTelemetry
implements FullQueueCallback,
ServiceTaskCallback {
    private static final String LOG_TAG = "MapboxTelemetry";
    private static final String NON_NULL_APPLICATION_CONTEXT_REQUIRED = "Non-null application context required.";
    private static AtomicReference<String> sAccessToken = new AtomicReference<String>("");
    private String userAgent;
    private final EventsQueue queue;
    private TelemetryClient telemetryClient;
    private Callback httpCallback;
    private final SchedulerFlusher schedulerFlusher;
    private Clock clock = null;
    private final TelemetryEnabler telemetryEnabler;
    private CopyOnWriteArraySet<TelemetryListener> telemetryListeners = null;
    private CertificateBlacklist certificateBlacklist;
    private CopyOnWriteArraySet<AttachmentListener> attachmentListeners = null;
    private ConfigurationClient configurationClient;
    private final ExecutorService executorService;
    static Context applicationContext = null;

    public MapboxTelemetry(Context context, String accessToken, String userAgent) {
        this.initializeContext(context);
        this.executorService = ExecutorServiceFactory.create("MapboxTelemetryExecutor", 3, 20L);
        MapboxTelemetry.setAccessToken(context, accessToken, this.executorService);
        this.userAgent = userAgent;
        AlarmReceiver alarmReceiver = this.obtainAlarmReceiver();
        this.schedulerFlusher = new SchedulerFlusherFactory(applicationContext, alarmReceiver).supply();
        this.telemetryEnabler = new TelemetryEnabler(true);
        this.initializeTelemetryListeners();
        this.initializeAttachmentListeners();
        this.httpCallback = MapboxTelemetry.getHttpCallback(this.telemetryListeners);
        this.queue = EventsQueue.create(this, this.executorService);
    }

    MapboxTelemetry(Context context, String accessToken, String userAgent, EventsQueue queue, TelemetryClient telemetryClient, Callback httpCallback, SchedulerFlusher schedulerFlusher, Clock clock, TelemetryEnabler telemetryEnabler, ExecutorService executorService) {
        this.initializeContext(context);
        MapboxTelemetry.setAccessToken(context, accessToken, executorService);
        this.userAgent = userAgent;
        this.telemetryClient = telemetryClient;
        this.schedulerFlusher = schedulerFlusher;
        this.clock = clock;
        this.telemetryEnabler = telemetryEnabler;
        this.initializeTelemetryListeners();
        this.initializeAttachmentListeners();
        this.httpCallback = httpCallback;
        this.executorService = executorService;
        this.queue = queue;
    }

    @Override
    public void onFullQueue(List<Event> fullQueue) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState) && !TelemetryUtils.adjustWakeUpMode(applicationContext)) {
            this.sendEvents(fullQueue, false);
        }
    }

    @Override
    public void onTaskRemoved() {
        this.flushEnqueuedEvents();
        this.unregisterTelemetry();
    }

    public boolean push(Event event) {
        if (this.sendEventIfWhitelisted(event)) {
            return true;
        }
        return this.pushToQueue(event);
    }

    public boolean enable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            this.startTelemetry();
            return true;
        }
        return false;
    }

    public boolean disable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            this.stopTelemetry();
            return true;
        }
        return false;
    }

    public boolean updateSessionIdRotationInterval(SessionInterval interval) {
        final long intervalHours = interval.obtainInterval();
        this.executeRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(applicationContext);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putLong("mapboxSessionRotationInterval", TimeUnit.HOURS.toMillis(intervalHours));
                    editor.apply();
                }
                catch (Throwable throwable) {
                    Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                }
            }
        });
        return true;
    }

    public void updateDebugLoggingEnabled(boolean isDebugLoggingEnabled) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateDebugLoggingEnabled(isDebugLoggingEnabled);
        }
    }

    public void updateUserAgent(String userAgent) {
        if (this.isUserAgentValid(userAgent)) {
            this.telemetryClient.updateUserAgent(TelemetryUtils.createFullUserAgent(userAgent, applicationContext));
        }
    }

    public boolean updateAccessToken(String accessToken) {
        if (this.isAccessTokenValid(accessToken) && this.updateTelemetryClient(accessToken)) {
            sAccessToken.set(accessToken);
            return true;
        }
        return false;
    }

    public boolean addTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.add(listener);
    }

    public boolean removeTelemetryListener(TelemetryListener listener) {
        return this.telemetryListeners.remove(listener);
    }

    public boolean addAttachmentListener(AttachmentListener listener) {
        return this.attachmentListeners.add(listener);
    }

    public boolean removeAttachmentListener(AttachmentListener listener) {
        return this.attachmentListeners.remove(listener);
    }

    boolean isQueueEmpty() {
        return this.queue.isEmpty();
    }

    boolean checkRequiredParameters(String accessToken, String userAgent) {
        boolean areValidParameters = this.areRequiredParametersValid(accessToken, userAgent);
        if (areValidParameters) {
            this.initializeTelemetryClient();
        }
        return areValidParameters;
    }

    private void initializeContext(Context context) {
        if (applicationContext == null) {
            if (context != null && context.getApplicationContext() != null) {
                applicationContext = context.getApplicationContext();
            } else {
                throw new IllegalArgumentException(NON_NULL_APPLICATION_CONTEXT_REQUIRED);
            }
        }
    }

    private boolean areRequiredParametersValid(String accessToken, String userAgent) {
        return this.isAccessTokenValid(accessToken) && this.isUserAgentValid(userAgent);
    }

    private boolean isAccessTokenValid(String accessToken) {
        if (!TelemetryUtils.isEmpty(accessToken)) {
            sAccessToken.set(accessToken);
            return true;
        }
        return false;
    }

    private boolean isUserAgentValid(String userAgent) {
        if (!TelemetryUtils.isEmpty(userAgent)) {
            this.userAgent = userAgent;
            return true;
        }
        return false;
    }

    private void initializeTelemetryClient() {
        if (this.configurationClient == null) {
            this.configurationClient = new ConfigurationClient(applicationContext, TelemetryUtils.createFullUserAgent(this.userAgent, applicationContext), sAccessToken.get(), new OkHttpClient());
        }
        if (this.certificateBlacklist == null) {
            this.certificateBlacklist = new CertificateBlacklist(applicationContext, this.configurationClient);
        }
        if (this.telemetryClient == null) {
            this.telemetryClient = this.createTelemetryClient(sAccessToken.get(), this.userAgent);
        }
    }

    private TelemetryClient createTelemetryClient(String accessToken, String userAgent) {
        String fullUserAgent = TelemetryUtils.createFullUserAgent(userAgent, applicationContext);
        TelemetryClientFactory telemetryClientFactory = new TelemetryClientFactory(accessToken, fullUserAgent, new Logger(), this.certificateBlacklist);
        this.telemetryClient = telemetryClientFactory.obtainTelemetryClient(applicationContext);
        return this.telemetryClient;
    }

    private boolean updateTelemetryClient(String accessToken) {
        if (this.telemetryClient != null) {
            this.telemetryClient.updateAccessToken(accessToken);
            return true;
        }
        return false;
    }

    private AlarmReceiver obtainAlarmReceiver() {
        return new AlarmReceiver(new SchedulerCallback(){

            @Override
            public void onPeriodRaised() {
                MapboxTelemetry.this.flushEnqueuedEvents();
            }

            @Override
            public void onError() {
            }
        });
    }

    private synchronized void flushEnqueuedEvents() {
        final List<Event> currentEvents = this.queue.flush();
        if (currentEvents.isEmpty()) {
            return;
        }
        this.executeRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    MapboxTelemetry.this.sendEvents(currentEvents, false);
                }
                catch (Throwable throwable) {
                    Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                }
            }
        });
    }

    private boolean isNetworkConnected() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            if (activeNetwork == null) {
                return false;
            }
            return activeNetwork.isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void sendEvents(List<Event> events, boolean serializeNulls) {
        if (this.isNetworkConnected() && this.checkRequiredParameters(sAccessToken.get(), this.userAgent)) {
            this.telemetryClient.sendEvents(events, this.httpCallback, serializeNulls);
        }
    }

    private void initializeTelemetryListeners() {
        this.telemetryListeners = new CopyOnWriteArraySet();
    }

    private void initializeAttachmentListeners() {
        this.attachmentListeners = new CopyOnWriteArraySet();
    }

    private boolean pushToQueue(Event event) {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            return this.queue.push(event);
        }
        return false;
    }

    private void unregisterTelemetry() {
        this.schedulerFlusher.unregister();
    }

    private synchronized boolean sendEventIfWhitelisted(Event event) {
        boolean isEventSent = false;
        switch (event.obtainType()) {
            case TURNSTILE: 
            case CRASH: {
                final List<Event> events = Collections.singletonList(event);
                this.executeRunnable(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MapboxTelemetry.this.sendEvents(events, true);
                        }
                        catch (Throwable throwable) {
                            Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                        }
                    }
                });
                isEventSent = true;
                break;
            }
            case VIS_ATTACHMENT: {
                this.sendAttachment(event);
                isEventSent = true;
                break;
            }
        }
        return isEventSent;
    }

    private void startTelemetry() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.startAlarm();
            this.enableLocationCollector(true);
        }
    }

    private void startAlarm() {
        this.schedulerFlusher.register();
        Clock clock = this.obtainClock();
        this.schedulerFlusher.schedule(clock.giveMeTheElapsedRealtime());
    }

    private Clock obtainClock() {
        if (this.clock == null) {
            this.clock = new Clock();
        }
        return this.clock;
    }

    private void stopTelemetry() {
        TelemetryEnabler.State telemetryState = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.flushEnqueuedEvents();
            this.unregisterTelemetry();
            this.enableLocationCollector(false);
        }
    }

    private synchronized void enableLocationCollector(final boolean enable) {
        this.executeRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(applicationContext);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putBoolean("mapboxTelemetryLocationState", enable);
                    editor.apply();
                }
                catch (Throwable throwable) {
                    Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                }
            }
        });
    }

    private static synchronized void setAccessToken(@NonNull Context context, @NonNull String accessToken, @NonNull ExecutorService executorService) {
        if (TelemetryUtils.isEmpty(accessToken)) {
            return;
        }
        if (sAccessToken.getAndSet(accessToken).isEmpty()) {
            ErrorReporterEngine.sendErrorReports(context, executorService);
        }
    }

    private void executeRunnable(Runnable command) {
        try {
            this.executorService.execute(command);
        }
        catch (RejectedExecutionException rex) {
            Log.e((String)LOG_TAG, (String)rex.toString());
        }
    }

    private void sendAttachment(Event event) {
        if (this.checkNetworkAndParameters().booleanValue()) {
            this.telemetryClient.sendAttachment(this.convertEventToAttachment(event), this.attachmentListeners);
        }
    }

    private Attachment convertEventToAttachment(Event event) {
        return (Attachment)event;
    }

    private Boolean checkNetworkAndParameters() {
        return this.isNetworkConnected() && this.checkRequiredParameters(sAccessToken.get(), this.userAgent);
    }

    private static Callback getHttpCallback(final Set<TelemetryListener> listeners) {
        return new Callback(){

            public void onFailure(Call call, IOException e) {
                for (TelemetryListener telemetryListener : listeners) {
                    telemetryListener.onHttpFailure(e.getMessage());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody body = response.body();
                if (body != null) {
                    body.close();
                }
                for (TelemetryListener telemetryListener : listeners) {
                    telemetryListener.onHttpResponse(response.isSuccessful(), response.code());
                }
            }
        };
    }

    public synchronized boolean setBaseUrl(String eventsHost) {
        if (MapboxTelemetry.isValidUrl(eventsHost) && this.checkNetworkAndParameters().booleanValue()) {
            this.telemetryClient.setBaseUrl(eventsHost);
            return true;
        }
        return false;
    }

    private static boolean isValidUrl(String eventsHost) {
        Pattern urlPattern = Pattern.compile("^[a-z0-9]+([\\-.][a-z0-9]+)*\\.[a-z]{2,5}(:[0-9]{1,5})?(/.*)?$");
        return eventsHost != null && !eventsHost.isEmpty() && urlPattern.matcher(eventsHost).matches();
    }

    private static final class ExecutorServiceFactory {
        private ExecutorServiceFactory() {
        }

        private static synchronized ExecutorService create(String name, int maxSize, long keepAliveSeconds) {
            return new ThreadPoolExecutor(0, maxSize, keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorServiceFactory.threadFactory(name));
        }

        private static ThreadFactory threadFactory(final String name) {
            return new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, name);
                }
            };
        }
    }
}

