/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.mapbox.android.telemetry.MapboxTelemetry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import okio.Buffer;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class TelemetryUtils {
    static final String MAPBOX_SHARED_PREFERENCES = "MapboxSharedPreferences";
    static final String MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID = "mapboxVendorId";
    private static final String KEY_META_DATA_WAKE_UP = "com.mapbox.AdjustWakeUp";
    private static final String DATE_AND_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String EMPTY_STRING = "";
    private static final String TWO_STRING_FORMAT = "%s %s";
    private static final String THREE_STRING_FORMAT = "%s/%s/%s";
    private static final SimpleDateFormat dateFormat;
    private static final Locale DEFAULT_LOCALE;
    private static final int UNAVAILABLE_BATTERY_LEVEL = -1;
    private static final int DEFAULT_BATTERY_LEVEL = -1;
    private static final int PERCENT_SCALE = 100;
    private static final String FOREGROUND = "Foreground";
    private static final String BACKGROUND = "Background";
    private static final String NO_STATE = "";
    private static final String SINGLE_CARRIER_RTT = "1xRTT";
    private static final String CODE_DIVISION_MULTIPLE_ACCESS = "CDMA";
    private static final String ENHANCED_DATA_GSM_EVOLUTION = "EDGE";
    private static final String ENHANCED_HIGH_RATE_PACKET_DATA = "EHRPD";
    private static final String EVOLUTION_DATA_OPTIMIZED_0 = "EVDO_0";
    private static final String EVOLUTION_DATA_OPTIMIZED_A = "EVDO_A";
    private static final String EVOLUTION_DATA_OPTIMIZED_B = "EVDO_B";
    private static final String GENERAL_PACKET_RADIO_SERVICE = "GPRS";
    private static final String HIGH_SPEED_DOWNLINK_PACKET_ACCESS = "HSDPA";
    private static final String HIGH_SPEED_PACKET_ACCESS = "HSPA";
    private static final String HIGH_SPEED_PACKET_ACCESS_PLUS = "HSPAP";
    private static final String HIGH_SPEED_UNLINK_PACKET_ACCESS = "HSUPA";
    private static final String INTEGRATED_DIGITAL_ENHANCED_NETWORK = "IDEN";
    private static final String LONG_TERM_EVOLUTION = "LTE";
    private static final String UNIVERSAL_MOBILE_TELCO_SERVICE = "UMTS";
    private static final String UNKNOWN = "Unknown";
    private static final Map<Integer, String> NETWORKS;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public TelemetryUtils() {
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        blArray[0] = true;
    }

    /*
     * Unable to fully structure code
     */
    public static String toHumanReadableAscii(String var0) {
        var1_1 = TelemetryUtils.$jacocoInit();
        var3_3 = s.length();
        var1_1[1] = true;
        for (i = 0; i < length; i += Character.charCount(c)) {
            block6: {
                block5: {
                    block4: {
                        var1_1[2] = true;
                        c = s.codePointAt(i);
                        if (c > 31) break block4;
                        var1_1[3] = true;
                        break block5;
                    }
                    if (c < 127) break block6;
                    var1_1[4] = true;
                }
                var5_5 = new Buffer();
                var1_1[5] = true;
                buffer.writeUtf8(s, 0, i);
                var6_6 = i;
                var1_1[6] = true;
                while (j < length) {
                    block7: {
                        var1_1[7] = true;
                        c = s.codePointAt((int)j);
                        var1_1[8] = true;
                        if (c > 31) break block7;
                        var1_1[9] = true;
                        ** GOTO lbl33
                    }
                    if (c < 127) {
                        v0 = c;
                        var1_1[11] = true;
                    } else {
                        var1_1[10] = true;
lbl33:
                        // 2 sources

                        v0 = 63;
                        var1_1[12] = true;
                    }
                    buffer.writeUtf8CodePoint(v0);
                    var1_1[13] = true;
                    j += Character.charCount(c);
                    var1_1[14] = true;
                }
                var1_1[15] = true;
                return buffer.readUtf8();
            }
            var1_1[16] = true;
        }
        var1_1[17] = true;
        return s;
    }

    public static String obtainUniversalUniqueIdentifier() {
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        String universalUniqueIdentifier = UUID.randomUUID().toString();
        blArray[18] = true;
        return universalUniqueIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    static String obtainApplicationState(Context context) {
        void activityManager;
        Context context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        ActivityManager activityManager2 = (ActivityManager)context2.getSystemService("activity");
        blArray[19] = true;
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            blArray[20] = true;
            return "";
        }
        String string = context2.getPackageName();
        blArray[21] = true;
        Iterator iterator = appProcesses.iterator();
        blArray[22] = true;
        while (iterator.hasNext()) {
            ActivityManager.RunningAppProcessInfo appProcess = (ActivityManager.RunningAppProcessInfo)iterator.next();
            if (appProcess.importance != 100) {
                blArray[23] = true;
            } else {
                void packageName;
                blArray[24] = true;
                if (!appProcess.processName.equals(packageName)) {
                    blArray[25] = true;
                } else {
                    blArray[26] = true;
                    return FOREGROUND;
                }
            }
            blArray[27] = true;
        }
        blArray[28] = true;
        return BACKGROUND;
    }

    /*
     * WARNING - void declaration
     */
    static int obtainBatteryLevel(Context context) {
        void scale;
        void level;
        Context context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        Intent batteryStatus = TelemetryUtils.registerBatteryUpdates(context2);
        if (batteryStatus == null) {
            blArray[29] = true;
            return -1;
        }
        int n = batteryStatus.getIntExtra("level", -1);
        blArray[30] = true;
        int n2 = batteryStatus.getIntExtra("scale", -1);
        blArray[31] = true;
        blArray[32] = true;
        return Math.round((float)level / (float)scale * 100.0f);
    }

    /*
     * Unable to fully structure code
     */
    static boolean isPluggedIn(Context var0) {
        block7: {
            var1_1 = TelemetryUtils.$jacocoInit();
            batteryStatus = TelemetryUtils.registerBatteryUpdates(context);
            if (batteryStatus == null) {
                var1_1[33] = true;
                return false;
            }
            chargePlug = batteryStatus.getIntExtra("plugged", -1);
            if (chargePlug == 2) {
                v0 = var1_1[34] = true;
            } else {
                v0 = false;
                var1_1[35] = true;
            }
            pluggedIntoUSB = v0;
            if (chargePlug == 1) {
                v1 = var1_1[36] = true;
            } else {
                v1 = false;
                var1_1[37] = true;
            }
            pluggedIntoAC = v1;
            if (!pluggedIntoUSB) break block7;
            var1_1[38] = true;
            ** GOTO lbl25
        }
        if (pluggedIntoAC) {
            var1_1[39] = true;
lbl25:
            // 2 sources

            v2 = var1_1[40] = true;
        } else {
            v2 = false;
            var1_1[41] = true;
        }
        var1_1[42] = true;
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    static String obtainCellularNetworkType(Context context) {
        void telephonyManager;
        Context context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        TelephonyManager telephonyManager2 = (TelephonyManager)context2.getSystemService("phone");
        blArray[43] = true;
        blArray[44] = true;
        return NETWORKS.get(telephonyManager.getNetworkType());
    }

    static String obtainCurrentDate() {
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        blArray[45] = true;
        return dateFormat.format(new Date());
    }

    static String generateCreateDateFormatted(Date date) {
        Date date2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        blArray[46] = true;
        return dateFormat.format(date2);
    }

    /*
     * WARNING - void declaration
     */
    static String createFullUserAgent(String string, Context context) {
        String string2;
        String userAgent;
        void appIdentifier;
        void context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        String string3 = TelemetryUtils.obtainApplicationIdentifier((Context)context2);
        blArray[47] = true;
        String string4 = TelemetryUtils.toHumanReadableAscii(String.format(DEFAULT_LOCALE, TWO_STRING_FORMAT, appIdentifier, userAgent));
        blArray[48] = true;
        if (TextUtils.isEmpty((CharSequence)appIdentifier)) {
            string2 = userAgent;
            blArray[49] = true;
        } else {
            void newUserAgent;
            string2 = newUserAgent;
            blArray[50] = true;
        }
        String fullUserAgent = string2;
        blArray[51] = true;
        return fullUserAgent;
    }

    static boolean isEmpty(String string) {
        block4: {
            block3: {
                String string2;
                block2: {
                    boolean[] blArray = TelemetryUtils.$jacocoInit();
                    if (string2 != null) break block2;
                    blArray[52] = true;
                    break block3;
                }
                if (string2.length() != 0) break block4;
                blArray[53] = true;
            }
            blArray[54] = true;
            return true;
        }
        blArray[55] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static String retrieveVendorId() {
        String mapboxVendorId;
        void sharedPreferences;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        if (MapboxTelemetry.applicationContext == null) {
            blArray[56] = true;
            blArray[57] = true;
            return TelemetryUtils.updateVendorId();
        }
        SharedPreferences sharedPreferences2 = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext);
        blArray[58] = true;
        String string = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, "");
        blArray[59] = true;
        if (!TelemetryUtils.isEmpty(mapboxVendorId)) {
            blArray[60] = true;
        } else {
            blArray[61] = true;
            mapboxVendorId = TelemetryUtils.updateVendorId();
            blArray[62] = true;
        }
        blArray[63] = true;
        return mapboxVendorId;
    }

    static SharedPreferences obtainSharedPreferences(Context context) {
        Context context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        blArray[64] = true;
        return context2.getSharedPreferences(MAPBOX_SHARED_PREFERENCES, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static String updateVendorId() {
        void editor;
        void sharedPreferences;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        String uniqueId = TelemetryUtils.obtainUniversalUniqueIdentifier();
        if (MapboxTelemetry.applicationContext == null) {
            blArray[65] = true;
            return uniqueId;
        }
        SharedPreferences sharedPreferences2 = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext);
        blArray[66] = true;
        SharedPreferences.Editor editor2 = sharedPreferences.edit();
        blArray[67] = true;
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, uniqueId);
        blArray[68] = true;
        editor.apply();
        blArray[69] = true;
        return uniqueId;
    }

    /*
     * WARNING - void declaration
     */
    private static String obtainApplicationIdentifier(Context context) {
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        try {
            void packageName;
            Context context2;
            String string = context2.getPackageName();
            blArray[70] = true;
            PackageInfo packageInfo = context2.getPackageManager().getPackageInfo((String)packageName, 0);
            Object[] objectArray = new Object[3];
            objectArray[0] = packageName;
            objectArray[1] = packageInfo.versionName;
            blArray[71] = true;
            objectArray[2] = packageInfo.versionCode;
            blArray[72] = true;
            blArray[73] = true;
            String appIdentifier = String.format(DEFAULT_LOCALE, THREE_STRING_FORMAT, objectArray);
            return appIdentifier;
        }
        catch (Exception exception) {
            blArray[74] = true;
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Intent registerBatteryUpdates(Context context) {
        void filter;
        Context context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        blArray[75] = true;
        blArray[76] = true;
        return context2.registerReceiver(null, (IntentFilter)filter);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isServiceRunning(Class<?> clazz, Context context) {
        void context2;
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        ActivityManager manager = (ActivityManager)context2.getSystemService("activity");
        if (manager == null) {
            blArray[77] = true;
            return false;
        }
        Iterator iterator = manager.getRunningServices(Integer.MAX_VALUE).iterator();
        blArray[78] = true;
        while (iterator.hasNext()) {
            void service;
            Class<?> serviceClass;
            ActivityManager.RunningServiceInfo runningServiceInfo = (ActivityManager.RunningServiceInfo)iterator.next();
            blArray[79] = true;
            if (serviceClass.getName().equals(service.service.getClassName())) {
                blArray[80] = true;
                return true;
            }
            blArray[81] = true;
        }
        blArray[82] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static boolean adjustWakeUpMode(Context context) {
        block4: {
            boolean[] blArray = TelemetryUtils.$jacocoInit();
            try {
                Context context2;
                ApplicationInfo appInformation = context2.getPackageManager().getApplicationInfo(context2.getPackageName(), 128);
                if (appInformation == null) {
                    blArray[83] = true;
                    break block4;
                }
                if (appInformation.metaData == null) {
                    blArray[84] = true;
                    break block4;
                }
                blArray[85] = true;
                blArray[86] = true;
                boolean adjustWakeUp = appInformation.metaData.getBoolean(KEY_META_DATA_WAKE_UP, false);
                return adjustWakeUp;
            }
            catch (PackageManager.NameNotFoundException appInformation) {
                void exception;
                blArray[88] = true;
                exception.printStackTrace();
                blArray[89] = true;
            }
        }
        blArray[87] = true;
        blArray[90] = true;
        return false;
    }

    static {
        boolean[] blArray = TelemetryUtils.$jacocoInit();
        dateFormat = new SimpleDateFormat(DATE_AND_TIME_PATTERN, Locale.US);
        DEFAULT_LOCALE = Locale.US;
        blArray[91] = true;
        NETWORKS = new HashMap<Integer, String>(){
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 1.$jacocoInit();
                blArray[0] = true;
                this.put(7, TelemetryUtils.SINGLE_CARRIER_RTT);
                blArray[1] = true;
                this.put(4, TelemetryUtils.CODE_DIVISION_MULTIPLE_ACCESS);
                blArray[2] = true;
                this.put(2, TelemetryUtils.ENHANCED_DATA_GSM_EVOLUTION);
                blArray[3] = true;
                this.put(14, TelemetryUtils.ENHANCED_HIGH_RATE_PACKET_DATA);
                blArray[4] = true;
                this.put(5, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_0);
                blArray[5] = true;
                this.put(6, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_A);
                blArray[6] = true;
                this.put(12, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_B);
                blArray[7] = true;
                this.put(1, TelemetryUtils.GENERAL_PACKET_RADIO_SERVICE);
                blArray[8] = true;
                this.put(8, TelemetryUtils.HIGH_SPEED_DOWNLINK_PACKET_ACCESS);
                blArray[9] = true;
                this.put(10, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS);
                blArray[10] = true;
                this.put(15, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS_PLUS);
                blArray[11] = true;
                this.put(9, TelemetryUtils.HIGH_SPEED_UNLINK_PACKET_ACCESS);
                blArray[12] = true;
                this.put(11, TelemetryUtils.INTEGRATED_DIGITAL_ENHANCED_NETWORK);
                blArray[13] = true;
                this.put(13, TelemetryUtils.LONG_TERM_EVOLUTION);
                blArray[14] = true;
                this.put(3, TelemetryUtils.UNIVERSAL_MOBILE_TELCO_SERVICE);
                blArray[15] = true;
                this.put(0, TelemetryUtils.UNKNOWN);
                blArray[16] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)5119219794113929977L, (String)"com/mapbox/android/telemetry/TelemetryUtils$1", (int)17);
                }
                return blArray;
            }
        };
        blArray[92] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-375000491257828066L, (String)"com/mapbox/android/telemetry/TelemetryUtils", (int)93);
        }
        return blArray;
    }
}

