/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.support.annotation.Nullable;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.CertificatePinnerFactory;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.GzipRequestInterceptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class TelemetryClientSettings {
    private static final String STAGING_EVENTS_HOST = "api-events-staging.tilestream.net";
    private static final String COM_EVENTS_HOST = "events.mapbox.com";
    private static final String CHINA_EVENTS_HOST = "events.mapbox.cn";
    private static final Map<Environment, String> HOSTS;
    private static final String HTTPS_SCHEME = "https";
    private Environment environment;
    private final OkHttpClient client;
    private final HttpUrl baseUrl;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager x509TrustManager;
    private final HostnameVerifier hostnameVerifier;
    private boolean debugLoggingEnabled;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    TelemetryClientSettings(Builder builder) {
        void builder2;
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        this.environment = builder2.environment;
        this.client = builder2.client;
        this.baseUrl = builder2.baseUrl;
        this.sslSocketFactory = builder2.sslSocketFactory;
        this.x509TrustManager = builder2.x509TrustManager;
        this.hostnameVerifier = builder2.hostnameVerifier;
        this.debugLoggingEnabled = builder2.debugLoggingEnabled;
        blArray[0] = true;
    }

    Environment getEnvironment() {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[1] = true;
        return this.environment;
    }

    /*
     * WARNING - void declaration
     */
    OkHttpClient getClient(CertificateBlacklist certificateBlacklist) {
        void certificateBlacklist2;
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[2] = true;
        return this.configureHttpClient((CertificateBlacklist)certificateBlacklist2, new GzipRequestInterceptor());
    }

    /*
     * WARNING - void declaration
     */
    OkHttpClient getAttachmentClient(CertificateBlacklist certificateBlacklist) {
        void certificateBlacklist2;
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[3] = true;
        return this.configureHttpClient((CertificateBlacklist)certificateBlacklist2, null);
    }

    HttpUrl getBaseUrl() {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[4] = true;
        return this.baseUrl;
    }

    boolean isDebugLoggingEnabled() {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[5] = true;
        return this.debugLoggingEnabled;
    }

    Builder toBuilder() {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        return new Builder().environment(this.environment).client(this.client).baseUrl(this.baseUrl).sslSocketFactory(this.sslSocketFactory).x509TrustManager(this.x509TrustManager).hostnameVerifier(this.hostnameVerifier).debugLoggingEnabled(this.debugLoggingEnabled);
    }

    /*
     * WARNING - void declaration
     */
    static HttpUrl configureUrlHostname(String string) {
        String eventsHost;
        void builder;
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        HttpUrl.Builder builder2 = new HttpUrl.Builder().scheme(HTTPS_SCHEME);
        blArray[14] = true;
        builder.host(eventsHost);
        blArray[15] = true;
        blArray[16] = true;
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private OkHttpClient configureHttpClient(CertificateBlacklist certificateBlacklist, @Nullable Interceptor interceptor) {
        void interceptor2;
        void certificateBlacklist2;
        void factory;
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        CertificatePinnerFactory certificatePinnerFactory = new CertificatePinnerFactory();
        blArray[17] = true;
        blArray[18] = true;
        blArray[19] = true;
        blArray[20] = true;
        OkHttpClient.Builder builder = this.client.newBuilder().retryOnConnectionFailure(true).certificatePinner(factory.provideCertificatePinnerFor(this.environment, (CertificateBlacklist)certificateBlacklist2)).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS));
        if (interceptor2 == null) {
            blArray[21] = true;
        } else {
            blArray[22] = true;
            builder.addInterceptor((Interceptor)interceptor2);
            blArray[23] = true;
        }
        if (!this.isSocketFactoryUnset(this.sslSocketFactory, this.x509TrustManager)) {
            blArray[24] = true;
        } else {
            blArray[25] = true;
            builder.sslSocketFactory(this.sslSocketFactory, this.x509TrustManager);
            blArray[26] = true;
            builder.hostnameVerifier(this.hostnameVerifier);
            blArray[27] = true;
        }
        blArray[28] = true;
        return builder.build();
    }

    /*
     * Unable to fully structure code
     */
    private boolean isSocketFactoryUnset(SSLSocketFactory var1_1, X509TrustManager var2_2) {
        block2: {
            var3_3 = TelemetryClientSettings.$jacocoInit();
            if (sslSocketFactory != null) break block2;
            var3_3[29] = true;
            ** GOTO lbl10
        }
        if (x509TrustManager != null) {
            v0 = var3_3[31] = true;
        } else {
            var3_3[30] = true;
lbl10:
            // 2 sources

            v0 = false;
            var3_3[32] = true;
        }
        var3_3[33] = true;
        return v0;
    }

    static /* synthetic */ Map access$000() {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        blArray[34] = true;
        return HOSTS;
    }

    static {
        boolean[] blArray = TelemetryClientSettings.$jacocoInit();
        HOSTS = new HashMap<Environment, String>(){
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 1.$jacocoInit();
                blArray[0] = true;
                this.put(Environment.STAGING, TelemetryClientSettings.STAGING_EVENTS_HOST);
                blArray[1] = true;
                this.put(Environment.COM, TelemetryClientSettings.COM_EVENTS_HOST);
                blArray[2] = true;
                this.put(Environment.CHINA, TelemetryClientSettings.CHINA_EVENTS_HOST);
                blArray[3] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)47252781180165356L, (String)"com/mapbox/android/telemetry/TelemetryClientSettings$1", (int)4);
                }
                return blArray;
            }
        };
        blArray[35] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-7644863277217819260L, (String)"com/mapbox/android/telemetry/TelemetryClientSettings", (int)36);
        }
        return blArray;
    }

    static final class Builder {
        Environment environment;
        OkHttpClient client;
        HttpUrl baseUrl;
        SSLSocketFactory sslSocketFactory;
        X509TrustManager x509TrustManager;
        HostnameVerifier hostnameVerifier;
        boolean debugLoggingEnabled;
        private static transient /* synthetic */ boolean[] $jacocoData;

        Builder() {
            boolean[] blArray = Builder.$jacocoInit();
            this.environment = Environment.COM;
            blArray[0] = true;
            this.client = new OkHttpClient();
            this.baseUrl = null;
            this.sslSocketFactory = null;
            this.x509TrustManager = null;
            this.hostnameVerifier = null;
            this.debugLoggingEnabled = false;
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        Builder environment(Environment environment) {
            void environment2;
            boolean[] blArray = Builder.$jacocoInit();
            this.environment = environment2;
            blArray[2] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder client(OkHttpClient okHttpClient) {
            void client;
            boolean[] blArray = Builder.$jacocoInit();
            if (client == null) {
                blArray[3] = true;
            } else {
                this.client = client;
                blArray[4] = true;
            }
            blArray[5] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder baseUrl(HttpUrl httpUrl) {
            void baseUrl;
            boolean[] blArray = Builder.$jacocoInit();
            if (baseUrl == null) {
                blArray[6] = true;
            } else {
                this.baseUrl = baseUrl;
                blArray[7] = true;
            }
            blArray[8] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            void sslSocketFactory;
            boolean[] blArray = Builder.$jacocoInit();
            this.sslSocketFactory = sslSocketFactory;
            blArray[9] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder x509TrustManager(X509TrustManager x509TrustManager) {
            void x509TrustManager2;
            boolean[] blArray = Builder.$jacocoInit();
            this.x509TrustManager = x509TrustManager2;
            blArray[10] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            void hostnameVerifier2;
            boolean[] blArray = Builder.$jacocoInit();
            this.hostnameVerifier = hostnameVerifier2;
            blArray[11] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder debugLoggingEnabled(boolean bl) {
            void debugLoggingEnabled;
            boolean[] blArray = Builder.$jacocoInit();
            this.debugLoggingEnabled = debugLoggingEnabled;
            blArray[12] = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        TelemetryClientSettings build() {
            boolean[] blArray = Builder.$jacocoInit();
            if (this.baseUrl != null) {
                blArray[13] = true;
            } else {
                void eventsHost;
                blArray[14] = true;
                String string = (String)TelemetryClientSettings.access$000().get((Object)this.environment);
                blArray[15] = true;
                this.baseUrl = TelemetryClientSettings.configureUrlHostname((String)eventsHost);
                blArray[16] = true;
            }
            blArray[17] = true;
            return new TelemetryClientSettings(this);
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)6704188784926813356L, (String)"com/mapbox/android/telemetry/TelemetryClientSettings$Builder", (int)18);
            }
            return blArray;
        }
    }
}

