/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

public class TelemetryEnabler {
    static final String MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE = "mapboxTelemetryState";
    static final Map<State, Boolean> TELEMETRY_STATES = new HashMap<State, Boolean>(){
        {
            this.put(State.ENABLED, true);
            this.put(State.DISABLED, false);
        }
    };
    private static final Map<String, State> STATES = new HashMap<String, State>(){
        {
            this.put(State.ENABLED.name(), State.ENABLED);
            this.put(State.DISABLED.name(), State.DISABLED);
        }
    };
    private static final String KEY_META_DATA_ENABLED = "com.mapbox.EnableEvents";
    private boolean isFromPreferences = true;
    private State currentTelemetryState = State.ENABLED;

    TelemetryEnabler(boolean isFromPreferences) {
        this.isFromPreferences = isFromPreferences;
    }

    public static State retrieveTelemetryStateFromPreferences() {
        if (MapboxTelemetry.applicationContext == null) {
            return STATES.get(State.ENABLED.name());
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        String telemetryStateName = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, State.ENABLED.name());
        return STATES.get(telemetryStateName);
    }

    public static State updateTelemetryState(State telemetryState) {
        if (MapboxTelemetry.applicationContext == null) {
            return telemetryState;
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, telemetryState.name());
        editor.apply();
        return telemetryState;
    }

    State obtainTelemetryState() {
        if (this.isFromPreferences) {
            return TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        }
        return this.currentTelemetryState;
    }

    State updatePreferences(State telemetryState) {
        if (this.isFromPreferences) {
            return TelemetryEnabler.updateTelemetryState(telemetryState);
        }
        this.currentTelemetryState = telemetryState;
        return this.currentTelemetryState;
    }

    static boolean isEventsEnabled(Context context) {
        try {
            ApplicationInfo appInformation = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInformation != null && appInformation.metaData != null) {
                boolean isEnabled = appInformation.metaData.getBoolean(KEY_META_DATA_ENABLED, true);
                return isEnabled;
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static enum State {
        ENABLED,
        DISABLED;

    }
}

