/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.android.telemetry.NavigationUtils;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.Date;

public class NavigationMetadata
implements Parcelable {
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    private int absoluteDistanceToDestination;
    private Integer percentTimeInPortrait = null;
    private Integer percentTimeInForeground = null;
    private String startTimestamp;
    private int distanceCompleted;
    private int distanceRemaining;
    private int durationRemaining;
    private String operatingSystem;
    private int eventVersion;
    private String sdkIdentifier;
    private String sdkVersion;
    private String sessionIdentifier;
    private double lat;
    private double lng;
    private String geometry;
    private String created;
    private String profile;
    private Integer estimatedDistance = null;
    private Integer estimatedDuration = null;
    private Integer rerouteCount = null;
    private boolean simulation;
    private String originalRequestIdentifier = null;
    private String requestIdentifier = null;
    private String originalGeometry = null;
    private Integer originalEstimatedDistance = null;
    private Integer originalEstimatedDuration = null;
    private String audioType;
    private int stepCount;
    private Integer originalStepCount = null;
    private String device;
    private String locationEngine;
    private int volumeLevel;
    private int screenBrightness;
    private String applicationState;
    private Boolean batteryPluggedIn;
    private int batteryLevel;
    private String connectivity;
    private String tripIdentifier;
    private int legIndex;
    private int legCount;
    private int stepIndex;
    private Integer voiceIndex = null;
    private Integer bannerIndex = null;
    private int totalStepCount;
    public static final Parcelable.Creator<NavigationMetadata> CREATOR = new Parcelable.Creator<NavigationMetadata>(){

        public NavigationMetadata createFromParcel(Parcel in) {
            return new NavigationMetadata(in);
        }

        public NavigationMetadata[] newArray(int size) {
            return new NavigationMetadata[size];
        }
    };

    public NavigationMetadata(Date startTimestamp, int distanceCompleted, int distanceRemaining, int durationRemaining, String sdkIdentifier, String sdkVersion, int eventVersion, String sessionIdentifier, double lat, double lng, String geometry, String profile, boolean isSimulation, String locationEngine, int absoluteDistanceToDestination, String tripIdentifier, int legIndex, int legCount, int stepIndex, int stepCount, int totalStepCount) {
        this.startTimestamp = TelemetryUtils.generateCreateDateFormatted(startTimestamp);
        this.distanceCompleted = distanceCompleted;
        this.distanceRemaining = distanceRemaining;
        this.durationRemaining = durationRemaining;
        this.operatingSystem = OPERATING_SYSTEM;
        this.sdkIdentifier = sdkIdentifier;
        this.sdkVersion = sdkVersion;
        this.eventVersion = eventVersion;
        this.sessionIdentifier = sessionIdentifier;
        this.lat = lat;
        this.lng = lng;
        this.geometry = geometry;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.profile = profile;
        this.simulation = isSimulation;
        this.device = Build.MODEL;
        this.locationEngine = locationEngine;
        this.absoluteDistanceToDestination = absoluteDistanceToDestination;
        this.volumeLevel = 0;
        this.batteryLevel = 0;
        this.screenBrightness = 0;
        this.batteryPluggedIn = false;
        this.connectivity = "";
        this.audioType = "";
        this.applicationState = "";
        this.tripIdentifier = tripIdentifier;
        this.legIndex = legIndex;
        this.legCount = legCount;
        this.stepIndex = stepIndex;
        this.stepCount = stepCount;
        this.totalStepCount = totalStepCount;
    }

    NavigationMetadata setDeviceInfo(Context context) {
        this.volumeLevel = NavigationUtils.obtainVolumeLevel(context);
        this.batteryLevel = TelemetryUtils.obtainBatteryLevel(context);
        this.screenBrightness = NavigationUtils.obtainScreenBrightness(context);
        this.batteryPluggedIn = TelemetryUtils.isPluggedIn(context);
        this.connectivity = TelemetryUtils.obtainCellularNetworkType(context);
        this.audioType = NavigationUtils.obtainAudioType(context);
        this.applicationState = TelemetryUtils.obtainApplicationState(context);
        return this;
    }

    public void setCreated(Date created) {
        this.created = TelemetryUtils.generateCreateDateFormatted(created);
    }

    String getCreated() {
        return this.created;
    }

    String getStartTimestamp() {
        return this.startTimestamp;
    }

    Integer getDistanceCompleted() {
        return this.distanceCompleted;
    }

    Integer getDistanceRemaining() {
        return this.distanceRemaining;
    }

    Integer getDurationRemaining() {
        return this.durationRemaining;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    int getEventVersion() {
        return this.eventVersion;
    }

    String getSdKIdentifier() {
        return this.sdkIdentifier;
    }

    String getSdkVersion() {
        return this.sdkVersion;
    }

    String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    double getLat() {
        return this.lat;
    }

    double getLng() {
        return this.lng;
    }

    String getGeometry() {
        return this.geometry;
    }

    String getProfile() {
        return this.profile;
    }

    Integer getEstimatedDistance() {
        return this.estimatedDistance;
    }

    public void setEstimatedDistance(Integer estimatedDistance) {
        this.estimatedDistance = estimatedDistance;
    }

    Integer getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(Integer estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    Integer getRerouteCount() {
        return this.rerouteCount;
    }

    public void setRerouteCount(Integer rerouteCount) {
        this.rerouteCount = rerouteCount;
    }

    boolean isSimulation() {
        return this.simulation;
    }

    String getOriginalRequestIdentifier() {
        return this.originalRequestIdentifier;
    }

    public void setOriginalRequestIdentifier(String originalRequestIdentifier) {
        this.originalRequestIdentifier = originalRequestIdentifier;
    }

    String getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setRequestIdentifier(String requestIdentifier) {
        this.requestIdentifier = requestIdentifier;
    }

    String getOriginalGeometry() {
        return this.originalGeometry;
    }

    public void setOriginalGeometry(String originalGeometry) {
        this.originalGeometry = originalGeometry;
    }

    Integer getOriginalEstimatedDistance() {
        return this.originalEstimatedDistance;
    }

    public void setOriginalEstimatedDistance(Integer originalEstimatedDistance) {
        this.originalEstimatedDistance = originalEstimatedDistance;
    }

    Integer getOriginalEstimatedDuration() {
        return this.originalEstimatedDuration;
    }

    public void setOriginalEstimatedDuration(Integer originalEstimatedDuration) {
        this.originalEstimatedDuration = originalEstimatedDuration;
    }

    String getAudioType() {
        return this.audioType;
    }

    Integer getOriginalStepCount() {
        return this.originalStepCount;
    }

    public void setOriginalStepCount(Integer originalStepCount) {
        this.originalStepCount = originalStepCount;
    }

    String getDevice() {
        return this.device;
    }

    String getLocationEngine() {
        return this.locationEngine;
    }

    Integer getVolumeLevel() {
        return this.volumeLevel;
    }

    Integer getScreenBrightness() {
        return this.screenBrightness;
    }

    String getApplicationState() {
        return this.applicationState;
    }

    Boolean isBatteryPluggedIn() {
        return this.batteryPluggedIn;
    }

    void setBatteryLevel(Integer batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    Integer getBatteryLevel() {
        return this.batteryLevel;
    }

    String getConnectivity() {
        return this.connectivity;
    }

    int getAbsoluteDistanceToDestination() {
        return this.absoluteDistanceToDestination;
    }

    Integer getPercentTimeInPortrait() {
        return this.percentTimeInPortrait;
    }

    public void setPercentTimeInPortrait(Integer percentTimeInPortrait) {
        this.percentTimeInPortrait = percentTimeInPortrait;
    }

    Integer getPercentTimeInForeground() {
        return this.percentTimeInForeground;
    }

    public void setPercentTimeInForeground(Integer percentTimeInForeground) {
        this.percentTimeInForeground = percentTimeInForeground;
    }

    String getTripIdentifier() {
        return this.tripIdentifier;
    }

    Integer getLegIndex() {
        return this.legIndex;
    }

    Integer getLegCount() {
        return this.legCount;
    }

    Integer getStepIndex() {
        return this.stepIndex;
    }

    Integer getStepCount() {
        return this.stepCount;
    }

    Integer getVoiceIndex() {
        return this.voiceIndex;
    }

    void setVoiceIndex(int voiceIndex) {
        this.voiceIndex = voiceIndex;
    }

    Integer getBannerIndex() {
        return this.bannerIndex;
    }

    public void setBannerIndex(int bannerIndex) {
        this.bannerIndex = bannerIndex;
    }

    Integer getTotalStepCount() {
        return this.totalStepCount;
    }

    private NavigationMetadata(Parcel in) {
        this.absoluteDistanceToDestination = in.readInt();
        this.percentTimeInPortrait = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.percentTimeInForeground = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.startTimestamp = in.readString();
        this.distanceCompleted = in.readInt();
        this.distanceRemaining = in.readInt();
        this.durationRemaining = in.readInt();
        this.operatingSystem = in.readString();
        this.eventVersion = in.readInt();
        this.sdkIdentifier = in.readString();
        this.sdkVersion = in.readString();
        this.sessionIdentifier = in.readString();
        this.lat = in.readDouble();
        this.lng = in.readDouble();
        this.geometry = in.readString();
        this.created = in.readString();
        this.profile = in.readString();
        this.estimatedDistance = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.estimatedDuration = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.rerouteCount = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.simulation = in.readByte() != 0;
        this.originalRequestIdentifier = in.readString();
        this.requestIdentifier = in.readString();
        this.originalGeometry = in.readString();
        this.originalEstimatedDistance = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.originalEstimatedDuration = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.audioType = in.readString();
        this.originalStepCount = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.device = in.readString();
        this.locationEngine = in.readString();
        this.volumeLevel = in.readInt();
        this.screenBrightness = in.readInt();
        this.applicationState = in.readString();
        this.batteryPluggedIn = in.readByte() != 0;
        this.batteryLevel = in.readInt();
        this.connectivity = in.readString();
        this.tripIdentifier = in.readString();
        this.legIndex = in.readInt();
        this.legCount = in.readInt();
        this.stepIndex = in.readInt();
        this.stepCount = in.readInt();
        this.voiceIndex = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.bannerIndex = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.totalStepCount = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.absoluteDistanceToDestination);
        if (this.percentTimeInPortrait == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.percentTimeInPortrait.intValue());
        }
        if (this.percentTimeInForeground == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.percentTimeInForeground.intValue());
        }
        dest.writeString(this.startTimestamp);
        dest.writeInt(this.distanceCompleted);
        dest.writeInt(this.distanceRemaining);
        dest.writeInt(this.durationRemaining);
        dest.writeString(this.operatingSystem);
        dest.writeInt(this.eventVersion);
        dest.writeString(this.sdkIdentifier);
        dest.writeString(this.sdkVersion);
        dest.writeString(this.sessionIdentifier);
        dest.writeDouble(this.lat);
        dest.writeDouble(this.lng);
        dest.writeString(this.geometry);
        dest.writeString(this.created);
        dest.writeString(this.profile);
        if (this.estimatedDistance == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.estimatedDistance.intValue());
        }
        if (this.estimatedDuration == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.estimatedDuration.intValue());
        }
        if (this.rerouteCount == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.rerouteCount.intValue());
        }
        dest.writeByte((byte)(this.simulation ? 1 : 0));
        dest.writeString(this.originalRequestIdentifier);
        dest.writeString(this.requestIdentifier);
        dest.writeString(this.originalGeometry);
        if (this.originalEstimatedDistance == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.originalEstimatedDistance.intValue());
        }
        if (this.originalEstimatedDuration == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.originalEstimatedDuration.intValue());
        }
        dest.writeString(this.audioType);
        if (this.originalStepCount == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.originalStepCount.intValue());
        }
        dest.writeString(this.device);
        dest.writeString(this.locationEngine);
        dest.writeInt(this.volumeLevel);
        dest.writeInt(this.screenBrightness);
        dest.writeString(this.applicationState);
        dest.writeByte((byte)(this.batteryPluggedIn != false ? 1 : 0));
        dest.writeInt(this.batteryLevel);
        dest.writeString(this.connectivity);
        dest.writeString(this.tripIdentifier);
        dest.writeInt(this.legIndex);
        dest.writeInt(this.legCount);
        dest.writeInt(this.stepIndex);
        dest.writeInt(this.stepCount);
        if (this.voiceIndex == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.voiceIndex.intValue());
        }
        if (this.bannerIndex == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.bannerIndex.intValue());
        }
        dest.writeInt(this.totalStepCount);
    }
}

